/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6Address;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6AddressesListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInterface> {
    private static final SdkField<NetworkInterfaceAssociation> ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Association").getter(NetworkInterface.getter(NetworkInterface::association)).setter(NetworkInterface.setter(Builder::association)).constructor(NetworkInterfaceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").unmarshallLocationName("association").build()}).build();
    private static final SdkField<NetworkInterfaceAttachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(NetworkInterface.getter(NetworkInterface::attachment)).setter(NetworkInterface.setter(Builder::attachment)).constructor(NetworkInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").unmarshallLocationName("attachment").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(NetworkInterface.getter(NetworkInterface::availabilityZone)).setter(NetworkInterface.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(NetworkInterface.getter(NetworkInterface::description)).setter(NetworkInterface.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(NetworkInterface.getter(NetworkInterface::groups)).setter(NetworkInterface.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterfaceType").getter(NetworkInterface.getter(NetworkInterface::interfaceTypeAsString)).setter(NetworkInterface.setter(Builder::interfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").unmarshallLocationName("interfaceType").build()}).build();
    private static final SdkField<List<NetworkInterfaceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(NetworkInterface.getter(NetworkInterface::ipv6Addresses)).setter(NetworkInterface.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesSet").unmarshallLocationName("ipv6AddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterfaceIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAddress").getter(NetworkInterface.getter(NetworkInterface::macAddress)).setter(NetworkInterface.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").unmarshallLocationName("macAddress").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(NetworkInterface.getter(NetworkInterface::networkInterfaceId)).setter(NetworkInterface.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(NetworkInterface.getter(NetworkInterface::outpostArn)).setter(NetworkInterface.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(NetworkInterface.getter(NetworkInterface::ownerId)).setter(NetworkInterface.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsName").getter(NetworkInterface.getter(NetworkInterface::privateDnsName)).setter(NetworkInterface.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("privateDnsName").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(NetworkInterface.getter(NetworkInterface::privateIpAddress)).setter(NetworkInterface.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<List<NetworkInterfacePrivateIpAddress>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(NetworkInterface.getter(NetworkInterface::privateIpAddresses)).setter(NetworkInterface.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressesSet").unmarshallLocationName("privateIpAddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterfacePrivateIpAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> REQUESTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterId").getter(NetworkInterface.getter(NetworkInterface::requesterId)).setter(NetworkInterface.setter(Builder::requesterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterId").unmarshallLocationName("requesterId").build()}).build();
    private static final SdkField<Boolean> REQUESTER_MANAGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequesterManaged").getter(NetworkInterface.getter(NetworkInterface::requesterManaged)).setter(NetworkInterface.setter(Builder::requesterManaged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterManaged").unmarshallLocationName("requesterManaged").build()}).build();
    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SourceDestCheck").getter(NetworkInterface.getter(NetworkInterface::sourceDestCheck)).setter(NetworkInterface.setter(Builder::sourceDestCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NetworkInterface.getter(NetworkInterface::statusAsString)).setter(NetworkInterface.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(NetworkInterface.getter(NetworkInterface::subnetId)).setter(NetworkInterface.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<List<Tag>> TAG_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSet").getter(NetworkInterface.getter(NetworkInterface::tagSet)).setter(NetworkInterface.setter(Builder::tagSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(NetworkInterface.getter(NetworkInterface::vpcId)).setter(NetworkInterface.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD, ATTACHMENT_FIELD, AVAILABILITY_ZONE_FIELD, DESCRIPTION_FIELD, GROUPS_FIELD, INTERFACE_TYPE_FIELD, IPV6_ADDRESSES_FIELD, MAC_ADDRESS_FIELD, NETWORK_INTERFACE_ID_FIELD, OUTPOST_ARN_FIELD, OWNER_ID_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, REQUESTER_ID_FIELD, REQUESTER_MANAGED_FIELD, SOURCE_DEST_CHECK_FIELD, STATUS_FIELD, SUBNET_ID_FIELD, TAG_SET_FIELD, VPC_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final NetworkInterfaceAssociation association;
    private final NetworkInterfaceAttachment attachment;
    private final String availabilityZone;
    private final String description;
    private final List<GroupIdentifier> groups;
    private final String interfaceType;
    private final List<NetworkInterfaceIpv6Address> ipv6Addresses;
    private final String macAddress;
    private final String networkInterfaceId;
    private final String outpostArn;
    private final String ownerId;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final List<NetworkInterfacePrivateIpAddress> privateIpAddresses;
    private final String requesterId;
    private final Boolean requesterManaged;
    private final Boolean sourceDestCheck;
    private final String status;
    private final String subnetId;
    private final List<Tag> tagSet;
    private final String vpcId;

    private NetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.outpostArn = builder.outpostArn;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.requesterId = builder.requesterId;
        this.requesterManaged = builder.requesterManaged;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tagSet = builder.tagSet;
        this.vpcId = builder.vpcId;
    }

    public NetworkInterfaceAssociation association() {
        return this.association;
    }

    public NetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String description() {
        return this.description;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public NetworkInterfaceType interfaceType() {
        return NetworkInterfaceType.fromValue(this.interfaceType);
    }

    public String interfaceTypeAsString() {
        return this.interfaceType;
    }

    public boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public List<NetworkInterfaceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String outpostArn() {
        return this.outpostArn;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public List<NetworkInterfacePrivateIpAddress> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public String requesterId() {
        return this.requesterId;
    }

    public Boolean requesterManaged() {
        return this.requesterManaged;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public NetworkInterfaceStatus status() {
        return NetworkInterfaceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public boolean hasTagSet() {
        return this.tagSet != null && !(this.tagSet instanceof SdkAutoConstructList);
    }

    public List<Tag> tagSet() {
        return this.tagSet;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterManaged());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        return Objects.equals(this.association(), other.association()) && Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.interfaceTypeAsString(), other.interfaceTypeAsString()) && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.requesterId(), other.requesterId()) && Objects.equals(this.requesterManaged(), other.requesterManaged()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.tagSet(), other.tagSet()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInterface").add("Association", (Object)this.association()).add("Attachment", (Object)this.attachment()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Description", (Object)this.description()).add("Groups", this.groups()).add("InterfaceType", (Object)this.interfaceTypeAsString()).add("Ipv6Addresses", this.ipv6Addresses()).add("MacAddress", (Object)this.macAddress()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("OutpostArn", (Object)this.outpostArn()).add("OwnerId", (Object)this.ownerId()).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PrivateIpAddresses", this.privateIpAddresses()).add("RequesterId", (Object)this.requesterId()).add("RequesterManaged", (Object)this.requesterManaged()).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("Status", (Object)this.statusAsString()).add("SubnetId", (Object)this.subnetId()).add("TagSet", this.tagSet()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.ofNullable(clazz.cast(this.association()));
            }
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "InterfaceType": {
                return Optional.ofNullable(clazz.cast(this.interfaceTypeAsString()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "RequesterId": {
                return Optional.ofNullable(clazz.cast(this.requesterId()));
            }
            case "RequesterManaged": {
                return Optional.ofNullable(clazz.cast(this.requesterManaged()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "TagSet": {
                return Optional.ofNullable(clazz.cast(this.tagSet()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkInterfaceAssociation association;
        private NetworkInterfaceAttachment attachment;
        private String availabilityZone;
        private String description;
        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();
        private String interfaceType;
        private List<NetworkInterfaceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String macAddress;
        private String networkInterfaceId;
        private String outpostArn;
        private String ownerId;
        private String privateDnsName;
        private String privateIpAddress;
        private List<NetworkInterfacePrivateIpAddress> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private String requesterId;
        private Boolean requesterManaged;
        private Boolean sourceDestCheck;
        private String status;
        private String subnetId;
        private List<Tag> tagSet = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            this.association(model.association);
            this.attachment(model.attachment);
            this.availabilityZone(model.availabilityZone);
            this.description(model.description);
            this.groups(model.groups);
            this.interfaceType(model.interfaceType);
            this.ipv6Addresses(model.ipv6Addresses);
            this.macAddress(model.macAddress);
            this.networkInterfaceId(model.networkInterfaceId);
            this.outpostArn(model.outpostArn);
            this.ownerId(model.ownerId);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddresses(model.privateIpAddresses);
            this.requesterId(model.requesterId);
            this.requesterManaged(model.requesterManaged);
            this.sourceDestCheck(model.sourceDestCheck);
            this.status(model.status);
            this.subnetId(model.subnetId);
            this.tagSet(model.tagSet);
            this.vpcId(model.vpcId);
        }

        public final NetworkInterfaceAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final NetworkInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(NetworkInterfaceType interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        public final Collection<NetworkInterfaceIpv6Address.Builder> getIpv6Addresses() {
            return this.ipv6Addresses != null ? (Collection)this.ipv6Addresses.stream().map(NetworkInterfaceIpv6Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(NetworkInterfaceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<NetworkInterfaceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (NetworkInterfaceIpv6Address)((NetworkInterfaceIpv6Address.Builder)NetworkInterfaceIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Addresses(Collection<NetworkInterfaceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<NetworkInterfacePrivateIpAddress.Builder> getPrivateIpAddresses() {
            return this.privateIpAddresses != null ? (Collection)this.privateIpAddresses.stream().map(NetworkInterfacePrivateIpAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(NetworkInterfacePrivateIpAddress ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<NetworkInterfacePrivateIpAddress.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (NetworkInterfacePrivateIpAddress)((NetworkInterfacePrivateIpAddress.Builder)NetworkInterfacePrivateIpAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        public final String getRequesterId() {
            return this.requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final Boolean getRequesterManaged() {
            return this.requesterManaged;
        }

        @Override
        public final Builder requesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
            return this;
        }

        public final void setRequesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<Tag.Builder> getTagSet() {
            return this.tagSet != null ? (Collection)this.tagSet.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagListCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Tag ... tagSet) {
            this.tagSet(Arrays.asList(tagSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Consumer<Tag.Builder> ... tagSet) {
            this.tagSet(Stream.of(tagSet).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSet(Collection<Tag.BuilderImpl> tagSet) {
            this.tagSet = TagListCopier.copyFromBuilder(tagSet);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInterface> {
        public Builder association(NetworkInterfaceAssociation var1);

        default public Builder association(Consumer<NetworkInterfaceAssociation.Builder> association) {
            return this.association((NetworkInterfaceAssociation)((NetworkInterfaceAssociation.Builder)NetworkInterfaceAssociation.builder().applyMutation(association)).build());
        }

        public Builder attachment(NetworkInterfaceAttachment var1);

        default public Builder attachment(Consumer<NetworkInterfaceAttachment.Builder> attachment) {
            return this.attachment((NetworkInterfaceAttachment)((NetworkInterfaceAttachment.Builder)NetworkInterfaceAttachment.builder().applyMutation(attachment)).build());
        }

        public Builder availabilityZone(String var1);

        public Builder description(String var1);

        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder groups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder interfaceType(String var1);

        public Builder interfaceType(NetworkInterfaceType var1);

        public Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> var1);

        public Builder ipv6Addresses(NetworkInterfaceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<NetworkInterfaceIpv6Address.Builder> ... var1);

        public Builder macAddress(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder outpostArn(String var1);

        public Builder ownerId(String var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> var1);

        public Builder privateIpAddresses(NetworkInterfacePrivateIpAddress ... var1);

        public Builder privateIpAddresses(Consumer<NetworkInterfacePrivateIpAddress.Builder> ... var1);

        public Builder requesterId(String var1);

        public Builder requesterManaged(Boolean var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder status(String var1);

        public Builder status(NetworkInterfaceStatus var1);

        public Builder subnetId(String var1);

        public Builder tagSet(Collection<Tag> var1);

        public Builder tagSet(Tag ... var1);

        public Builder tagSet(Consumer<Tag.Builder> ... var1);

        public Builder vpcId(String var1);
    }
}

