/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InstanceTagKeySetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterInstanceTagAttributeRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegisterInstanceTagAttributeRequest> {
    private static final SdkField<Boolean> INCLUDE_ALL_TAGS_OF_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeAllTagsOfInstance").getter(RegisterInstanceTagAttributeRequest.getter(RegisterInstanceTagAttributeRequest::includeAllTagsOfInstance)).setter(RegisterInstanceTagAttributeRequest.setter(Builder::includeAllTagsOfInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllTagsOfInstance").unmarshallLocationName("IncludeAllTagsOfInstance").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TAG_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTagKeys").getter(RegisterInstanceTagAttributeRequest.getter(RegisterInstanceTagAttributeRequest::instanceTagKeys)).setter(RegisterInstanceTagAttributeRequest.setter(Builder::instanceTagKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTagKey").unmarshallLocationName("InstanceTagKey").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_ALL_TAGS_OF_INSTANCE_FIELD, INSTANCE_TAG_KEYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean includeAllTagsOfInstance;
    private final List<String> instanceTagKeys;

    private RegisterInstanceTagAttributeRequest(BuilderImpl builder) {
        this.includeAllTagsOfInstance = builder.includeAllTagsOfInstance;
        this.instanceTagKeys = builder.instanceTagKeys;
    }

    public Boolean includeAllTagsOfInstance() {
        return this.includeAllTagsOfInstance;
    }

    public boolean hasInstanceTagKeys() {
        return this.instanceTagKeys != null && !(this.instanceTagKeys instanceof SdkAutoConstructList);
    }

    public List<String> instanceTagKeys() {
        return this.instanceTagKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAllTagsOfInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTagKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceTagAttributeRequest)) {
            return false;
        }
        RegisterInstanceTagAttributeRequest other = (RegisterInstanceTagAttributeRequest)obj;
        return Objects.equals(this.includeAllTagsOfInstance(), other.includeAllTagsOfInstance()) && Objects.equals(this.instanceTagKeys(), other.instanceTagKeys());
    }

    public String toString() {
        return ToString.builder((String)"RegisterInstanceTagAttributeRequest").add("IncludeAllTagsOfInstance", (Object)this.includeAllTagsOfInstance()).add("InstanceTagKeys", this.instanceTagKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IncludeAllTagsOfInstance": {
                return Optional.ofNullable(clazz.cast(this.includeAllTagsOfInstance()));
            }
            case "InstanceTagKeys": {
                return Optional.ofNullable(clazz.cast(this.instanceTagKeys()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterInstanceTagAttributeRequest, T> g) {
        return obj -> g.apply((RegisterInstanceTagAttributeRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean includeAllTagsOfInstance;
        private List<String> instanceTagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceTagAttributeRequest model) {
            this.includeAllTagsOfInstance(model.includeAllTagsOfInstance);
            this.instanceTagKeys(model.instanceTagKeys);
        }

        public final Boolean getIncludeAllTagsOfInstance() {
            return this.includeAllTagsOfInstance;
        }

        @Override
        public final Builder includeAllTagsOfInstance(Boolean includeAllTagsOfInstance) {
            this.includeAllTagsOfInstance = includeAllTagsOfInstance;
            return this;
        }

        public final void setIncludeAllTagsOfInstance(Boolean includeAllTagsOfInstance) {
            this.includeAllTagsOfInstance = includeAllTagsOfInstance;
        }

        public final Collection<String> getInstanceTagKeys() {
            return this.instanceTagKeys;
        }

        @Override
        public final Builder instanceTagKeys(Collection<String> instanceTagKeys) {
            this.instanceTagKeys = InstanceTagKeySetCopier.copy(instanceTagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTagKeys(String ... instanceTagKeys) {
            this.instanceTagKeys(Arrays.asList(instanceTagKeys));
            return this;
        }

        public final void setInstanceTagKeys(Collection<String> instanceTagKeys) {
            this.instanceTagKeys = InstanceTagKeySetCopier.copy(instanceTagKeys);
        }

        public RegisterInstanceTagAttributeRequest build() {
            return new RegisterInstanceTagAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegisterInstanceTagAttributeRequest> {
        public Builder includeAllTagsOfInstance(Boolean var1);

        public Builder instanceTagKeys(Collection<String> var1);

        public Builder instanceTagKeys(String ... var1);
    }
}

