/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VolumeAttachmentState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeAttachment> {
    private static final SdkField<Instant> ATTACH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VolumeAttachment.getter(VolumeAttachment::attachTime)).setter(VolumeAttachment.setter(Builder::attachTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").unmarshallLocationName("attachTime").build()}).build();
    private static final SdkField<String> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeAttachment.getter(VolumeAttachment::device)).setter(VolumeAttachment.setter(Builder::device)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").unmarshallLocationName("device").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeAttachment.getter(VolumeAttachment::instanceId)).setter(VolumeAttachment.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeAttachment.getter(VolumeAttachment::stateAsString)).setter(VolumeAttachment.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeAttachment.getter(VolumeAttachment::volumeId)).setter(VolumeAttachment.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VolumeAttachment.getter(VolumeAttachment::deleteOnTermination)).setter(VolumeAttachment.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACH_TIME_FIELD, DEVICE_FIELD, INSTANCE_ID_FIELD, STATE_FIELD, VOLUME_ID_FIELD, DELETE_ON_TERMINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant attachTime;
    private final String device;
    private final String instanceId;
    private final String state;
    private final String volumeId;
    private final Boolean deleteOnTermination;

    private VolumeAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.device = builder.device;
        this.instanceId = builder.instanceId;
        this.state = builder.state;
        this.volumeId = builder.volumeId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    public Instant attachTime() {
        return this.attachTime;
    }

    public String device() {
        return this.device;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public VolumeAttachmentState state() {
        return VolumeAttachmentState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeAttachment)) {
            return false;
        }
        VolumeAttachment other = (VolumeAttachment)obj;
        return Objects.equals(this.attachTime(), other.attachTime()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination());
    }

    public String toString() {
        return ToString.builder((String)"VolumeAttachment").add("AttachTime", (Object)this.attachTime()).add("Device", (Object)this.device()).add("InstanceId", (Object)this.instanceId()).add("State", (Object)this.stateAsString()).add("VolumeId", (Object)this.volumeId()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachTime": {
                return Optional.ofNullable(clazz.cast(this.attachTime()));
            }
            case "Device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeAttachment, T> g) {
        return obj -> g.apply((VolumeAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant attachTime;
        private String device;
        private String instanceId;
        private String state;
        private String volumeId;
        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeAttachment model) {
            this.attachTime(model.attachTime);
            this.device(model.device);
            this.instanceId(model.instanceId);
            this.state(model.state);
            this.volumeId(model.volumeId);
            this.deleteOnTermination(model.deleteOnTermination);
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeAttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public VolumeAttachment build() {
            return new VolumeAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeAttachment> {
        public Builder attachTime(Instant var1);

        public Builder device(String var1);

        public Builder instanceId(String var1);

        public Builder state(String var1);

        public Builder state(VolumeAttachmentState var1);

        public Builder volumeId(String var1);

        public Builder deleteOnTermination(Boolean var1);
    }
}

