/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DiskType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiskInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiskInfo> {
    private static final SdkField<Long> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DiskInfo.getter(DiskInfo::sizeInGB)).setter(DiskInfo.setter(Builder::sizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInGB").unmarshallLocationName("sizeInGB").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DiskInfo.getter(DiskInfo::count)).setter(DiskInfo.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("count").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskInfo.getter(DiskInfo::typeAsString)).setter(DiskInfo.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_IN_GB_FIELD, COUNT_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long sizeInGB;
    private final Integer count;
    private final String type;

    private DiskInfo(BuilderImpl builder) {
        this.sizeInGB = builder.sizeInGB;
        this.count = builder.count;
        this.type = builder.type;
    }

    public Long sizeInGB() {
        return this.sizeInGB;
    }

    public Integer count() {
        return this.count;
    }

    public DiskType type() {
        return DiskType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskInfo)) {
            return false;
        }
        DiskInfo other = (DiskInfo)obj;
        return Objects.equals(this.sizeInGB(), other.sizeInGB()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DiskInfo").add("SizeInGB", (Object)this.sizeInGB()).add("Count", (Object)this.count()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SizeInGB": {
                return Optional.ofNullable(clazz.cast(this.sizeInGB()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskInfo, T> g) {
        return obj -> g.apply((DiskInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long sizeInGB;
        private Integer count;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskInfo model) {
            this.sizeInGB(model.sizeInGB);
            this.count(model.count);
            this.type(model.type);
        }

        public final Long getSizeInGB() {
            return this.sizeInGB;
        }

        @Override
        public final Builder sizeInGB(Long sizeInGB) {
            this.sizeInGB = sizeInGB;
            return this;
        }

        public final void setSizeInGB(Long sizeInGB) {
            this.sizeInGB = sizeInGB;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DiskType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public DiskInfo build() {
            return new DiskInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiskInfo> {
        public Builder sizeInGB(Long var1);

        public Builder count(Integer var1);

        public Builder type(String var1);

        public Builder type(DiskType var1);
    }
}

