/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon EC2 launch template and the launch template version that can be used by an EC2 Fleet to
 * configure Amazon EC2 instances. For information about launch templates, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a
 * launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetLaunchTemplateSpecificationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetLaunchTemplateSpecificationRequest.Builder, FleetLaunchTemplateSpecificationRequest> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateSpecificationRequest::launchTemplateId))
            .setter(setter(Builder::launchTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId")
                    .unmarshallLocationName("LaunchTemplateId").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateSpecificationRequest::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName")
                    .unmarshallLocationName("LaunchTemplateName").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateSpecificationRequest::version))
            .setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version")
                    .unmarshallLocationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD,
            LAUNCH_TEMPLATE_NAME_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchTemplateId;

    private final String launchTemplateName;

    private final String version;

    private FleetLaunchTemplateSpecificationRequest(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.version = builder.version;
    }

    /**
     * <p>
     * The ID of the launch template. If you specify the template ID, you can't specify the template name.
     * </p>
     * 
     * @return The ID of the launch template. If you specify the template ID, you can't specify the template name.
     */
    public String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The name of the launch template. If you specify the template name, you can't specify the template ID.
     * </p>
     * 
     * @return The name of the launch template. If you specify the template name, you can't specify the template ID.
     */
    public String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * The launch template version number, <code>$Latest</code>, or <code>$Default</code>. You must specify a value,
     * otherwise the request fails.
     * </p>
     * <p>
     * If the value is <code>$Latest</code>, Amazon EC2 uses the latest version of the launch template.
     * </p>
     * <p>
     * If the value is <code>$Default</code>, Amazon EC2 uses the default version of the launch template.
     * </p>
     * 
     * @return The launch template version number, <code>$Latest</code>, or <code>$Default</code>. You must specify a
     *         value, otherwise the request fails.</p>
     *         <p>
     *         If the value is <code>$Latest</code>, Amazon EC2 uses the latest version of the launch template.
     *         </p>
     *         <p>
     *         If the value is <code>$Default</code>, Amazon EC2 uses the default version of the launch template.
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateSpecificationRequest)) {
            return false;
        }
        FleetLaunchTemplateSpecificationRequest other = (FleetLaunchTemplateSpecificationRequest) obj;
        return Objects.equals(launchTemplateId(), other.launchTemplateId())
                && Objects.equals(launchTemplateName(), other.launchTemplateName()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FleetLaunchTemplateSpecificationRequest").add("LaunchTemplateId", launchTemplateId())
                .add("LaunchTemplateName", launchTemplateName()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateSpecificationRequest, T> g) {
        return obj -> g.apply((FleetLaunchTemplateSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetLaunchTemplateSpecificationRequest> {
        /**
         * <p>
         * The ID of the launch template. If you specify the template ID, you can't specify the template name.
         * </p>
         * 
         * @param launchTemplateId
         *        The ID of the launch template. If you specify the template ID, you can't specify the template name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The name of the launch template. If you specify the template name, you can't specify the template ID.
         * </p>
         * 
         * @param launchTemplateName
         *        The name of the launch template. If you specify the template name, you can't specify the template ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * The launch template version number, <code>$Latest</code>, or <code>$Default</code>. You must specify a value,
         * otherwise the request fails.
         * </p>
         * <p>
         * If the value is <code>$Latest</code>, Amazon EC2 uses the latest version of the launch template.
         * </p>
         * <p>
         * If the value is <code>$Default</code>, Amazon EC2 uses the default version of the launch template.
         * </p>
         * 
         * @param version
         *        The launch template version number, <code>$Latest</code>, or <code>$Default</code>. You must specify a
         *        value, otherwise the request fails.</p>
         *        <p>
         *        If the value is <code>$Latest</code>, Amazon EC2 uses the latest version of the launch template.
         *        </p>
         *        <p>
         *        If the value is <code>$Default</code>, Amazon EC2 uses the default version of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String launchTemplateId;

        private String launchTemplateName;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateSpecificationRequest model) {
            launchTemplateId(model.launchTemplateId);
            launchTemplateName(model.launchTemplateName);
            version(model.version);
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public FleetLaunchTemplateSpecificationRequest build() {
            return new FleetLaunchTemplateSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
