/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpcEndpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcEndpointsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpcEndpointsResponse.Builder, DescribeVpcEndpointsResponse> {
    private static final SdkField<List<VpcEndpoint>> VPC_ENDPOINTS_FIELD = SdkField
            .<List<VpcEndpoint>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVpcEndpointsResponse::vpcEndpoints))
            .setter(setter(Builder::vpcEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointSet")
                    .unmarshallLocationName("vpcEndpointSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpcEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeVpcEndpointsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<VpcEndpoint> vpcEndpoints;

    private final String nextToken;

    private DescribeVpcEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpoints = builder.vpcEndpoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the VpcEndpoints property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVpcEndpoints() {
        return vpcEndpoints != null && !(vpcEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the endpoints.
     */
    public List<VpcEndpoint> vpcEndpoints() {
        return vpcEndpoints;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointsResponse)) {
            return false;
        }
        DescribeVpcEndpointsResponse other = (DescribeVpcEndpointsResponse) obj;
        return Objects.equals(vpcEndpoints(), other.vpcEndpoints()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVpcEndpointsResponse").add("VpcEndpoints", vpcEndpoints()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpoints":
            return Optional.ofNullable(clazz.cast(vpcEndpoints()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
        /**
         * <p>
         * Information about the endpoints.
         * </p>
         * 
         * @param vpcEndpoints
         *        Information about the endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints);

        /**
         * <p>
         * Information about the endpoints.
         * </p>
         * 
         * @param vpcEndpoints
         *        Information about the endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoints(VpcEndpoint... vpcEndpoints);

        /**
         * <p>
         * Information about the endpoints.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcEndpoint>.Builder} avoiding the need to
         * create one manually via {@link List<VpcEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcEndpoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcEndpoints(List<VpcEndpoint>)}.
         * 
         * @param vpcEndpoints
         *        a consumer that will call methods on {@link List<VpcEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpoints(List<VpcEndpoint>)
         */
        Builder vpcEndpoints(Consumer<VpcEndpoint.Builder>... vpcEndpoints);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<VpcEndpoint> vpcEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointsResponse model) {
            super(model);
            vpcEndpoints(model.vpcEndpoints);
            nextToken(model.nextToken);
        }

        public final Collection<VpcEndpoint.Builder> getVpcEndpoints() {
            return vpcEndpoints != null ? vpcEndpoints.stream().map(VpcEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copy(vpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(VpcEndpoint... vpcEndpoints) {
            vpcEndpoints(Arrays.asList(vpcEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(Consumer<VpcEndpoint.Builder>... vpcEndpoints) {
            vpcEndpoints(Stream.of(vpcEndpoints).map(c -> VpcEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVpcEndpoints(Collection<VpcEndpoint.BuilderImpl> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copyFromBuilder(vpcEndpoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointsResponse build() {
            return new DescribeVpcEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
