/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFleetsResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteFleetsResponse.Builder, DeleteFleetsResponse> {
    private static final SdkField<List<DeleteFleetSuccessItem>> SUCCESSFUL_FLEET_DELETIONS_FIELD = SdkField
            .<List<DeleteFleetSuccessItem>> builder(MarshallingType.LIST)
            .getter(getter(DeleteFleetsResponse::successfulFleetDeletions))
            .setter(setter(Builder::successfulFleetDeletions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulFleetDeletionSet")
                    .unmarshallLocationName("successfulFleetDeletionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DeleteFleetSuccessItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteFleetSuccessItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<DeleteFleetErrorItem>> UNSUCCESSFUL_FLEET_DELETIONS_FIELD = SdkField
            .<List<DeleteFleetErrorItem>> builder(MarshallingType.LIST)
            .getter(getter(DeleteFleetsResponse::unsuccessfulFleetDeletions))
            .setter(setter(Builder::unsuccessfulFleetDeletions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFleetDeletionSet")
                    .unmarshallLocationName("unsuccessfulFleetDeletionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DeleteFleetErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteFleetErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUCCESSFUL_FLEET_DELETIONS_FIELD, UNSUCCESSFUL_FLEET_DELETIONS_FIELD));

    private final List<DeleteFleetSuccessItem> successfulFleetDeletions;

    private final List<DeleteFleetErrorItem> unsuccessfulFleetDeletions;

    private DeleteFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulFleetDeletions = builder.successfulFleetDeletions;
        this.unsuccessfulFleetDeletions = builder.unsuccessfulFleetDeletions;
    }

    /**
     * Returns true if the SuccessfulFleetDeletions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSuccessfulFleetDeletions() {
        return successfulFleetDeletions != null && !(successfulFleetDeletions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the EC2 Fleets that are successfully deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessfulFleetDeletions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the EC2 Fleets that are successfully deleted.
     */
    public List<DeleteFleetSuccessItem> successfulFleetDeletions() {
        return successfulFleetDeletions;
    }

    /**
     * Returns true if the UnsuccessfulFleetDeletions property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasUnsuccessfulFleetDeletions() {
        return unsuccessfulFleetDeletions != null && !(unsuccessfulFleetDeletions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the EC2 Fleets that are not successfully deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnsuccessfulFleetDeletions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the EC2 Fleets that are not successfully deleted.
     */
    public List<DeleteFleetErrorItem> unsuccessfulFleetDeletions() {
        return unsuccessfulFleetDeletions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(successfulFleetDeletions());
        hashCode = 31 * hashCode + Objects.hashCode(unsuccessfulFleetDeletions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetsResponse)) {
            return false;
        }
        DeleteFleetsResponse other = (DeleteFleetsResponse) obj;
        return Objects.equals(successfulFleetDeletions(), other.successfulFleetDeletions())
                && Objects.equals(unsuccessfulFleetDeletions(), other.unsuccessfulFleetDeletions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteFleetsResponse").add("SuccessfulFleetDeletions", successfulFleetDeletions())
                .add("UnsuccessfulFleetDeletions", unsuccessfulFleetDeletions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulFleetDeletions":
            return Optional.ofNullable(clazz.cast(successfulFleetDeletions()));
        case "UnsuccessfulFleetDeletions":
            return Optional.ofNullable(clazz.cast(unsuccessfulFleetDeletions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetsResponse, T> g) {
        return obj -> g.apply((DeleteFleetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFleetsResponse> {
        /**
         * <p>
         * Information about the EC2 Fleets that are successfully deleted.
         * </p>
         * 
         * @param successfulFleetDeletions
         *        Information about the EC2 Fleets that are successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetDeletions(Collection<DeleteFleetSuccessItem> successfulFleetDeletions);

        /**
         * <p>
         * Information about the EC2 Fleets that are successfully deleted.
         * </p>
         * 
         * @param successfulFleetDeletions
         *        Information about the EC2 Fleets that are successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetDeletions(DeleteFleetSuccessItem... successfulFleetDeletions);

        /**
         * <p>
         * Information about the EC2 Fleets that are successfully deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeleteFleetSuccessItem>.Builder} avoiding
         * the need to create one manually via {@link List<DeleteFleetSuccessItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeleteFleetSuccessItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #successfulFleetDeletions(List<DeleteFleetSuccessItem>)}.
         * 
         * @param successfulFleetDeletions
         *        a consumer that will call methods on {@link List<DeleteFleetSuccessItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulFleetDeletions(List<DeleteFleetSuccessItem>)
         */
        Builder successfulFleetDeletions(Consumer<DeleteFleetSuccessItem.Builder>... successfulFleetDeletions);

        /**
         * <p>
         * Information about the EC2 Fleets that are not successfully deleted.
         * </p>
         * 
         * @param unsuccessfulFleetDeletions
         *        Information about the EC2 Fleets that are not successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFleetDeletions(Collection<DeleteFleetErrorItem> unsuccessfulFleetDeletions);

        /**
         * <p>
         * Information about the EC2 Fleets that are not successfully deleted.
         * </p>
         * 
         * @param unsuccessfulFleetDeletions
         *        Information about the EC2 Fleets that are not successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFleetDeletions(DeleteFleetErrorItem... unsuccessfulFleetDeletions);

        /**
         * <p>
         * Information about the EC2 Fleets that are not successfully deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeleteFleetErrorItem>.Builder} avoiding the
         * need to create one manually via {@link List<DeleteFleetErrorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeleteFleetErrorItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #unsuccessfulFleetDeletions(List<DeleteFleetErrorItem>)}.
         * 
         * @param unsuccessfulFleetDeletions
         *        a consumer that will call methods on {@link List<DeleteFleetErrorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessfulFleetDeletions(List<DeleteFleetErrorItem>)
         */
        Builder unsuccessfulFleetDeletions(Consumer<DeleteFleetErrorItem.Builder>... unsuccessfulFleetDeletions);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<DeleteFleetSuccessItem> successfulFleetDeletions = DefaultSdkAutoConstructList.getInstance();

        private List<DeleteFleetErrorItem> unsuccessfulFleetDeletions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetsResponse model) {
            super(model);
            successfulFleetDeletions(model.successfulFleetDeletions);
            unsuccessfulFleetDeletions(model.unsuccessfulFleetDeletions);
        }

        public final Collection<DeleteFleetSuccessItem.Builder> getSuccessfulFleetDeletions() {
            return successfulFleetDeletions != null ? successfulFleetDeletions.stream().map(DeleteFleetSuccessItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulFleetDeletions(Collection<DeleteFleetSuccessItem> successfulFleetDeletions) {
            this.successfulFleetDeletions = DeleteFleetSuccessSetCopier.copy(successfulFleetDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetDeletions(DeleteFleetSuccessItem... successfulFleetDeletions) {
            successfulFleetDeletions(Arrays.asList(successfulFleetDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetDeletions(Consumer<DeleteFleetSuccessItem.Builder>... successfulFleetDeletions) {
            successfulFleetDeletions(Stream.of(successfulFleetDeletions)
                    .map(c -> DeleteFleetSuccessItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulFleetDeletions(Collection<DeleteFleetSuccessItem.BuilderImpl> successfulFleetDeletions) {
            this.successfulFleetDeletions = DeleteFleetSuccessSetCopier.copyFromBuilder(successfulFleetDeletions);
        }

        public final Collection<DeleteFleetErrorItem.Builder> getUnsuccessfulFleetDeletions() {
            return unsuccessfulFleetDeletions != null ? unsuccessfulFleetDeletions.stream().map(DeleteFleetErrorItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessfulFleetDeletions(Collection<DeleteFleetErrorItem> unsuccessfulFleetDeletions) {
            this.unsuccessfulFleetDeletions = DeleteFleetErrorSetCopier.copy(unsuccessfulFleetDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetDeletions(DeleteFleetErrorItem... unsuccessfulFleetDeletions) {
            unsuccessfulFleetDeletions(Arrays.asList(unsuccessfulFleetDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetDeletions(Consumer<DeleteFleetErrorItem.Builder>... unsuccessfulFleetDeletions) {
            unsuccessfulFleetDeletions(Stream.of(unsuccessfulFleetDeletions)
                    .map(c -> DeleteFleetErrorItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessfulFleetDeletions(Collection<DeleteFleetErrorItem.BuilderImpl> unsuccessfulFleetDeletions) {
            this.unsuccessfulFleetDeletions = DeleteFleetErrorSetCopier.copyFromBuilder(unsuccessfulFleetDeletions);
        }

        @Override
        public DeleteFleetsResponse build() {
            return new DeleteFleetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
