/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouteTableResponse extends Ec2Response implements
        ToCopyableBuilder<CreateRouteTableResponse.Builder, CreateRouteTableResponse> {
    private static final SdkField<RouteTable> ROUTE_TABLE_FIELD = SdkField
            .<RouteTable> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateRouteTableResponse::routeTable))
            .setter(setter(Builder::routeTable))
            .constructor(RouteTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTable")
                    .unmarshallLocationName("routeTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_TABLE_FIELD));

    private final RouteTable routeTable;

    private CreateRouteTableResponse(BuilderImpl builder) {
        super(builder);
        this.routeTable = builder.routeTable;
    }

    /**
     * <p>
     * Information about the route table.
     * </p>
     * 
     * @return Information about the route table.
     */
    public RouteTable routeTable() {
        return routeTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeTable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteTableResponse)) {
            return false;
        }
        CreateRouteTableResponse other = (CreateRouteTableResponse) obj;
        return Objects.equals(routeTable(), other.routeTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRouteTableResponse").add("RouteTable", routeTable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteTable":
            return Optional.ofNullable(clazz.cast(routeTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteTableResponse, T> g) {
        return obj -> g.apply((CreateRouteTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateRouteTableResponse> {
        /**
         * <p>
         * Information about the route table.
         * </p>
         * 
         * @param routeTable
         *        Information about the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTable(RouteTable routeTable);

        /**
         * <p>
         * Information about the route table.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteTable.Builder} avoiding the need to create
         * one manually via {@link RouteTable#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteTable.Builder#build()} is called immediately and its result
         * is passed to {@link #routeTable(RouteTable)}.
         * 
         * @param routeTable
         *        a consumer that will call methods on {@link RouteTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTable(RouteTable)
         */
        default Builder routeTable(Consumer<RouteTable.Builder> routeTable) {
            return routeTable(RouteTable.builder().applyMutation(routeTable).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private RouteTable routeTable;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteTableResponse model) {
            super(model);
            routeTable(model.routeTable);
        }

        public final RouteTable.Builder getRouteTable() {
            return routeTable != null ? routeTable.toBuilder() : null;
        }

        @Override
        public final Builder routeTable(RouteTable routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        public final void setRouteTable(RouteTable.BuilderImpl routeTable) {
            this.routeTable = routeTable != null ? routeTable.build() : null;
        }

        @Override
        public CreateRouteTableResponse build() {
            return new CreateRouteTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
