/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVolumeAttributeResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVolumeAttributeResponse> {
    private static final SdkField<AttributeBooleanValue> AUTO_ENABLE_IO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeVolumeAttributeResponse.getter(DescribeVolumeAttributeResponse::autoEnableIO)).setter(DescribeVolumeAttributeResponse.setter(Builder::autoEnableIO)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableIO").unmarshallLocationName("autoEnableIO").build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeVolumeAttributeResponse.getter(DescribeVolumeAttributeResponse::productCodes)).setter(DescribeVolumeAttributeResponse.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").unmarshallLocationName("productCodes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVolumeAttributeResponse.getter(DescribeVolumeAttributeResponse::volumeId)).setter(DescribeVolumeAttributeResponse.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_IO_FIELD, PRODUCT_CODES_FIELD, VOLUME_ID_FIELD));
    private final AttributeBooleanValue autoEnableIO;
    private final List<ProductCode> productCodes;
    private final String volumeId;

    private DescribeVolumeAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnableIO = builder.autoEnableIO;
        this.productCodes = builder.productCodes;
        this.volumeId = builder.volumeId;
    }

    public AttributeBooleanValue autoEnableIO() {
        return this.autoEnableIO;
    }

    public boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableIO());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeAttributeResponse)) {
            return false;
        }
        DescribeVolumeAttributeResponse other = (DescribeVolumeAttributeResponse)((Object)obj);
        return Objects.equals(this.autoEnableIO(), other.autoEnableIO()) && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVolumeAttributeResponse").add("AutoEnableIO", (Object)this.autoEnableIO()).add("ProductCodes", this.productCodes()).add("VolumeId", (Object)this.volumeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnableIO": {
                return Optional.ofNullable(clazz.cast(this.autoEnableIO()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumeAttributeResponse, T> g) {
        return obj -> g.apply((DescribeVolumeAttributeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private AttributeBooleanValue autoEnableIO;
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeAttributeResponse model) {
            super(model);
            this.autoEnableIO(model.autoEnableIO);
            this.productCodes(model.productCodes);
            this.volumeId(model.volumeId);
        }

        public final AttributeBooleanValue.Builder getAutoEnableIO() {
            return this.autoEnableIO != null ? this.autoEnableIO.toBuilder() : null;
        }

        @Override
        public final Builder autoEnableIO(AttributeBooleanValue autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
            return this;
        }

        public final void setAutoEnableIO(AttributeBooleanValue.BuilderImpl autoEnableIO) {
            this.autoEnableIO = autoEnableIO != null ? autoEnableIO.build() : null;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public DescribeVolumeAttributeResponse build() {
            return new DescribeVolumeAttributeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVolumeAttributeResponse> {
        public Builder autoEnableIO(AttributeBooleanValue var1);

        default public Builder autoEnableIO(Consumer<AttributeBooleanValue.Builder> autoEnableIO) {
            return this.autoEnableIO((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(autoEnableIO)).build());
        }

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder volumeId(String var1);
    }
}

