/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.OccurrenceDayRequestSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledInstanceRecurrenceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledInstanceRecurrenceRequest> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduledInstanceRecurrenceRequest.getter(ScheduledInstanceRecurrenceRequest::frequency)).setter(ScheduledInstanceRecurrenceRequest.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").unmarshallLocationName("Frequency").build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScheduledInstanceRecurrenceRequest.getter(ScheduledInstanceRecurrenceRequest::interval)).setter(ScheduledInstanceRecurrenceRequest.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").unmarshallLocationName("Interval").build()}).build();
    private static final SdkField<List<Integer>> OCCURRENCE_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ScheduledInstanceRecurrenceRequest.getter(ScheduledInstanceRecurrenceRequest::occurrenceDays)).setter(ScheduledInstanceRecurrenceRequest.setter(Builder::occurrenceDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceDay").unmarshallLocationName("OccurrenceDay").build(), ListTrait.builder().memberLocationName("OccurenceDay").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurenceDay").unmarshallLocationName("OccurenceDay").build()}).build()).build()}).build();
    private static final SdkField<Boolean> OCCURRENCE_RELATIVE_TO_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ScheduledInstanceRecurrenceRequest.getter(ScheduledInstanceRecurrenceRequest::occurrenceRelativeToEnd)).setter(ScheduledInstanceRecurrenceRequest.setter(Builder::occurrenceRelativeToEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceRelativeToEnd").unmarshallLocationName("OccurrenceRelativeToEnd").build()}).build();
    private static final SdkField<String> OCCURRENCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduledInstanceRecurrenceRequest.getter(ScheduledInstanceRecurrenceRequest::occurrenceUnit)).setter(ScheduledInstanceRecurrenceRequest.setter(Builder::occurrenceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceUnit").unmarshallLocationName("OccurrenceUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD, INTERVAL_FIELD, OCCURRENCE_DAYS_FIELD, OCCURRENCE_RELATIVE_TO_END_FIELD, OCCURRENCE_UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String frequency;
    private final Integer interval;
    private final List<Integer> occurrenceDays;
    private final Boolean occurrenceRelativeToEnd;
    private final String occurrenceUnit;

    private ScheduledInstanceRecurrenceRequest(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.interval = builder.interval;
        this.occurrenceDays = builder.occurrenceDays;
        this.occurrenceRelativeToEnd = builder.occurrenceRelativeToEnd;
        this.occurrenceUnit = builder.occurrenceUnit;
    }

    public String frequency() {
        return this.frequency;
    }

    public Integer interval() {
        return this.interval;
    }

    public boolean hasOccurrenceDays() {
        return this.occurrenceDays != null && !(this.occurrenceDays instanceof SdkAutoConstructList);
    }

    public List<Integer> occurrenceDays() {
        return this.occurrenceDays;
    }

    public Boolean occurrenceRelativeToEnd() {
        return this.occurrenceRelativeToEnd;
    }

    public String occurrenceUnit() {
        return this.occurrenceUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrenceDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrenceRelativeToEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrenceUnit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceRecurrenceRequest)) {
            return false;
        }
        ScheduledInstanceRecurrenceRequest other = (ScheduledInstanceRecurrenceRequest)obj;
        return Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.occurrenceDays(), other.occurrenceDays()) && Objects.equals(this.occurrenceRelativeToEnd(), other.occurrenceRelativeToEnd()) && Objects.equals(this.occurrenceUnit(), other.occurrenceUnit());
    }

    public String toString() {
        return ToString.builder((String)"ScheduledInstanceRecurrenceRequest").add("Frequency", (Object)this.frequency()).add("Interval", (Object)this.interval()).add("OccurrenceDays", this.occurrenceDays()).add("OccurrenceRelativeToEnd", (Object)this.occurrenceRelativeToEnd()).add("OccurrenceUnit", (Object)this.occurrenceUnit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "OccurrenceDays": {
                return Optional.ofNullable(clazz.cast(this.occurrenceDays()));
            }
            case "OccurrenceRelativeToEnd": {
                return Optional.ofNullable(clazz.cast(this.occurrenceRelativeToEnd()));
            }
            case "OccurrenceUnit": {
                return Optional.ofNullable(clazz.cast(this.occurrenceUnit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstanceRecurrenceRequest, T> g) {
        return obj -> g.apply((ScheduledInstanceRecurrenceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String frequency;
        private Integer interval;
        private List<Integer> occurrenceDays = DefaultSdkAutoConstructList.getInstance();
        private Boolean occurrenceRelativeToEnd;
        private String occurrenceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceRecurrenceRequest model) {
            this.frequency(model.frequency);
            this.interval(model.interval);
            this.occurrenceDays(model.occurrenceDays);
            this.occurrenceRelativeToEnd(model.occurrenceRelativeToEnd);
            this.occurrenceUnit(model.occurrenceUnit);
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final Collection<Integer> getOccurrenceDays() {
            return this.occurrenceDays;
        }

        @Override
        public final Builder occurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder occurrenceDays(Integer ... occurrenceDays) {
            this.occurrenceDays(Arrays.asList(occurrenceDays));
            return this;
        }

        public final void setOccurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
        }

        public final Boolean getOccurrenceRelativeToEnd() {
            return this.occurrenceRelativeToEnd;
        }

        @Override
        public final Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
            return this;
        }

        public final void setOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
        }

        public final String getOccurrenceUnit() {
            return this.occurrenceUnit;
        }

        @Override
        public final Builder occurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
            return this;
        }

        public final void setOccurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
        }

        public ScheduledInstanceRecurrenceRequest build() {
            return new ScheduledInstanceRecurrenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledInstanceRecurrenceRequest> {
        public Builder frequency(String var1);

        public Builder interval(Integer var1);

        public Builder occurrenceDays(Collection<Integer> var1);

        public Builder occurrenceDays(Integer ... var1);

        public Builder occurrenceRelativeToEnd(Boolean var1);

        public Builder occurrenceUnit(String var1);
    }
}

