/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.PurchaseRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseRequestSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseScheduledInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PurchaseScheduledInstancesRequest.getter(PurchaseScheduledInstancesRequest::clientToken)).setter(PurchaseScheduledInstancesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<PurchaseRequest>> PURCHASE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PurchaseScheduledInstancesRequest.getter(PurchaseScheduledInstancesRequest::purchaseRequests)).setter(PurchaseScheduledInstancesRequest.setter(Builder::purchaseRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseRequest").unmarshallLocationName("PurchaseRequest").build(), ListTrait.builder().memberLocationName("PurchaseRequest").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PurchaseRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseRequest").unmarshallLocationName("PurchaseRequest").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, PURCHASE_REQUESTS_FIELD));
    private final String clientToken;
    private final List<PurchaseRequest> purchaseRequests;

    private PurchaseScheduledInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.purchaseRequests = builder.purchaseRequests;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public boolean hasPurchaseRequests() {
        return this.purchaseRequests != null && !(this.purchaseRequests instanceof SdkAutoConstructList);
    }

    public List<PurchaseRequest> purchaseRequests() {
        return this.purchaseRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesRequest)) {
            return false;
        }
        PurchaseScheduledInstancesRequest other = (PurchaseScheduledInstancesRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.purchaseRequests(), other.purchaseRequests());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseScheduledInstancesRequest").add("ClientToken", (Object)this.clientToken()).add("PurchaseRequests", this.purchaseRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "PurchaseRequests": {
                return Optional.ofNullable(clazz.cast(this.purchaseRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseScheduledInstancesRequest, T> g) {
        return obj -> g.apply((PurchaseScheduledInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private List<PurchaseRequest> purchaseRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.purchaseRequests(model.purchaseRequests);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<PurchaseRequest.Builder> getPurchaseRequests() {
            return this.purchaseRequests != null ? (Collection)this.purchaseRequests.stream().map(PurchaseRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copy(purchaseRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(PurchaseRequest ... purchaseRequests) {
            this.purchaseRequests(Arrays.asList(purchaseRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(Consumer<PurchaseRequest.Builder> ... purchaseRequests) {
            this.purchaseRequests(Stream.of(purchaseRequests).map(c -> (PurchaseRequest)((PurchaseRequest.Builder)PurchaseRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPurchaseRequests(Collection<PurchaseRequest.BuilderImpl> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copyFromBuilder(purchaseRequests);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseScheduledInstancesRequest build() {
            return new PurchaseScheduledInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
        public Builder clientToken(String var1);

        public Builder purchaseRequests(Collection<PurchaseRequest> var1);

        public Builder purchaseRequests(PurchaseRequest ... var1);

        public Builder purchaseRequests(Consumer<PurchaseRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

