/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a propagation route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayAttachmentPropagation implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayAttachmentPropagation.Builder, TransitGatewayAttachmentPropagation> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayAttachmentPropagation::transitGatewayRouteTableId))
            .setter(setter(Builder::transitGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId")
                    .unmarshallLocationName("transitGatewayRouteTableId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayAttachmentPropagation::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayRouteTableId;

    private final String state;

    private TransitGatewayAttachmentPropagation(BuilderImpl builder) {
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the propagation route table.
     * </p>
     * 
     * @return The ID of the propagation route table.
     */
    public String transitGatewayRouteTableId() {
        return transitGatewayRouteTableId;
    }

    /**
     * <p>
     * The state of the propagation route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayPropagationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the propagation route table.
     * @see TransitGatewayPropagationState
     */
    public TransitGatewayPropagationState state() {
        return TransitGatewayPropagationState.fromValue(state);
    }

    /**
     * <p>
     * The state of the propagation route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayPropagationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the propagation route table.
     * @see TransitGatewayPropagationState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayAttachmentPropagation)) {
            return false;
        }
        TransitGatewayAttachmentPropagation other = (TransitGatewayAttachmentPropagation) obj;
        return Objects.equals(transitGatewayRouteTableId(), other.transitGatewayRouteTableId())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayAttachmentPropagation")
                .add("TransitGatewayRouteTableId", transitGatewayRouteTableId()).add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayAttachmentPropagation, T> g) {
        return obj -> g.apply((TransitGatewayAttachmentPropagation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayAttachmentPropagation> {
        /**
         * <p>
         * The ID of the propagation route table.
         * </p>
         * 
         * @param transitGatewayRouteTableId
         *        The ID of the propagation route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableId(String transitGatewayRouteTableId);

        /**
         * <p>
         * The state of the propagation route table.
         * </p>
         * 
         * @param state
         *        The state of the propagation route table.
         * @see TransitGatewayPropagationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayPropagationState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the propagation route table.
         * </p>
         * 
         * @param state
         *        The state of the propagation route table.
         * @see TransitGatewayPropagationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayPropagationState
         */
        Builder state(TransitGatewayPropagationState state);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayRouteTableId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayAttachmentPropagation model) {
            transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            state(model.state);
        }

        public final String getTransitGatewayRouteTableId() {
            return transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayPropagationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public TransitGatewayAttachmentPropagation build() {
            return new TransitGatewayAttachmentPropagation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
