/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of RequestSpotInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestSpotInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<RequestSpotInstancesResponse.Builder, RequestSpotInstancesResponse> {
    private static final SdkField<List<SpotInstanceRequest>> SPOT_INSTANCE_REQUESTS_FIELD = SdkField
            .<List<SpotInstanceRequest>> builder(MarshallingType.LIST)
            .getter(getter(RequestSpotInstancesResponse::spotInstanceRequests))
            .setter(setter(Builder::spotInstanceRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestSet")
                    .unmarshallLocationName("spotInstanceRequestSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SpotInstanceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpotInstanceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_INSTANCE_REQUESTS_FIELD));

    private final List<SpotInstanceRequest> spotInstanceRequests;

    private RequestSpotInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.spotInstanceRequests = builder.spotInstanceRequests;
    }

    /**
     * Returns true if the SpotInstanceRequests property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSpotInstanceRequests() {
        return spotInstanceRequests != null && !(spotInstanceRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Spot Instance requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSpotInstanceRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more Spot Instance requests.
     */
    public List<SpotInstanceRequest> spotInstanceRequests() {
        return spotInstanceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotInstancesResponse)) {
            return false;
        }
        RequestSpotInstancesResponse other = (RequestSpotInstancesResponse) obj;
        return Objects.equals(spotInstanceRequests(), other.spotInstanceRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RequestSpotInstancesResponse").add("SpotInstanceRequests", spotInstanceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotInstanceRequests":
            return Optional.ofNullable(clazz.cast(spotInstanceRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestSpotInstancesResponse, T> g) {
        return obj -> g.apply((RequestSpotInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, RequestSpotInstancesResponse> {
        /**
         * <p>
         * One or more Spot Instance requests.
         * </p>
         * 
         * @param spotInstanceRequests
         *        One or more Spot Instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequests(Collection<SpotInstanceRequest> spotInstanceRequests);

        /**
         * <p>
         * One or more Spot Instance requests.
         * </p>
         * 
         * @param spotInstanceRequests
         *        One or more Spot Instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequests(SpotInstanceRequest... spotInstanceRequests);

        /**
         * <p>
         * One or more Spot Instance requests.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SpotInstanceRequest>.Builder} avoiding the
         * need to create one manually via {@link List<SpotInstanceRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SpotInstanceRequest>.Builder#build()} is called immediately
         * and its result is passed to {@link #spotInstanceRequests(List<SpotInstanceRequest>)}.
         * 
         * @param spotInstanceRequests
         *        a consumer that will call methods on {@link List<SpotInstanceRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotInstanceRequests(List<SpotInstanceRequest>)
         */
        Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder>... spotInstanceRequests);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SpotInstanceRequest> spotInstanceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotInstancesResponse model) {
            super(model);
            spotInstanceRequests(model.spotInstanceRequests);
        }

        public final Collection<SpotInstanceRequest.Builder> getSpotInstanceRequests() {
            return spotInstanceRequests != null ? spotInstanceRequests.stream().map(SpotInstanceRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder spotInstanceRequests(Collection<SpotInstanceRequest> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copy(spotInstanceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(SpotInstanceRequest... spotInstanceRequests) {
            spotInstanceRequests(Arrays.asList(spotInstanceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder>... spotInstanceRequests) {
            spotInstanceRequests(Stream.of(spotInstanceRequests).map(c -> SpotInstanceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSpotInstanceRequests(Collection<SpotInstanceRequest.BuilderImpl> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copyFromBuilder(spotInstanceRequests);
        }

        @Override
        public RequestSpotInstancesResponse build() {
            return new RequestSpotInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
