/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Spot Fleet request that was not successfully canceled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelSpotFleetRequestsErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<CancelSpotFleetRequestsErrorItem.Builder, CancelSpotFleetRequestsErrorItem> {
    private static final SdkField<CancelSpotFleetRequestsError> ERROR_FIELD = SdkField
            .<CancelSpotFleetRequestsError> builder(MarshallingType.SDK_POJO)
            .getter(getter(CancelSpotFleetRequestsErrorItem::error))
            .setter(setter(Builder::error))
            .constructor(CancelSpotFleetRequestsError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("error").build()).build();

    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CancelSpotFleetRequestsErrorItem::spotFleetRequestId))
            .setter(setter(Builder::spotFleetRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId")
                    .unmarshallLocationName("spotFleetRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD,
            SPOT_FLEET_REQUEST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final CancelSpotFleetRequestsError error;

    private final String spotFleetRequestId;

    private CancelSpotFleetRequestsErrorItem(BuilderImpl builder) {
        this.error = builder.error;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    /**
     * <p>
     * The error.
     * </p>
     * 
     * @return The error.
     */
    public CancelSpotFleetRequestsError error() {
        return error;
    }

    /**
     * <p>
     * The ID of the Spot Fleet request.
     * </p>
     * 
     * @return The ID of the Spot Fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsErrorItem)) {
            return false;
        }
        CancelSpotFleetRequestsErrorItem other = (CancelSpotFleetRequestsErrorItem) obj;
        return Objects.equals(error(), other.error()) && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CancelSpotFleetRequestsErrorItem").add("Error", error())
                .add("SpotFleetRequestId", spotFleetRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "SpotFleetRequestId":
            return Optional.ofNullable(clazz.cast(spotFleetRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotFleetRequestsErrorItem, T> g) {
        return obj -> g.apply((CancelSpotFleetRequestsErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CancelSpotFleetRequestsErrorItem> {
        /**
         * <p>
         * The error.
         * </p>
         * 
         * @param error
         *        The error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(CancelSpotFleetRequestsError error);

        /**
         * <p>
         * The error.
         * </p>
         * This is a convenience that creates an instance of the {@link CancelSpotFleetRequestsError.Builder} avoiding
         * the need to create one manually via {@link CancelSpotFleetRequestsError#builder()}.
         *
         * When the {@link Consumer} completes, {@link CancelSpotFleetRequestsError.Builder#build()} is called
         * immediately and its result is passed to {@link #error(CancelSpotFleetRequestsError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link CancelSpotFleetRequestsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(CancelSpotFleetRequestsError)
         */
        default Builder error(Consumer<CancelSpotFleetRequestsError.Builder> error) {
            return error(CancelSpotFleetRequestsError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The ID of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);
    }

    static final class BuilderImpl implements Builder {
        private CancelSpotFleetRequestsError error;

        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsErrorItem model) {
            error(model.error);
            spotFleetRequestId(model.spotFleetRequestId);
        }

        public final CancelSpotFleetRequestsError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        @Override
        public final Builder error(CancelSpotFleetRequestsError error) {
            this.error = error;
            return this;
        }

        public final void setError(CancelSpotFleetRequestsError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public CancelSpotFleetRequestsErrorItem build() {
            return new CancelSpotFleetRequestsErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
