/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateClientVpnTargetNetworkResponse extends Ec2Response implements
        ToCopyableBuilder<AssociateClientVpnTargetNetworkResponse.Builder, AssociateClientVpnTargetNetworkResponse> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateClientVpnTargetNetworkResponse::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId")
                    .unmarshallLocationName("associationId").build()).build();

    private static final SdkField<AssociationStatus> STATUS_FIELD = SdkField
            .<AssociationStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(AssociateClientVpnTargetNetworkResponse::status))
            .setter(setter(Builder::status))
            .constructor(AssociationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            STATUS_FIELD));

    private final String associationId;

    private final AssociationStatus status;

    private AssociateClientVpnTargetNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique ID of the target network association.
     * </p>
     * 
     * @return The unique ID of the target network association.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The current state of the target network association.
     * </p>
     * 
     * @return The current state of the target network association.
     */
    public AssociationStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateClientVpnTargetNetworkResponse)) {
            return false;
        }
        AssociateClientVpnTargetNetworkResponse other = (AssociateClientVpnTargetNetworkResponse) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateClientVpnTargetNetworkResponse").add("AssociationId", associationId())
                .add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateClientVpnTargetNetworkResponse, T> g) {
        return obj -> g.apply((AssociateClientVpnTargetNetworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateClientVpnTargetNetworkResponse> {
        /**
         * <p>
         * The unique ID of the target network association.
         * </p>
         * 
         * @param associationId
         *        The unique ID of the target network association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The current state of the target network association.
         * </p>
         * 
         * @param status
         *        The current state of the target network association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(AssociationStatus status);

        /**
         * <p>
         * The current state of the target network association.
         * </p>
         * This is a convenience that creates an instance of the {@link AssociationStatus.Builder} avoiding the need to
         * create one manually via {@link AssociationStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssociationStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(AssociationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link AssociationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(AssociationStatus)
         */
        default Builder status(Consumer<AssociationStatus.Builder> status) {
            return status(AssociationStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String associationId;

        private AssociationStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateClientVpnTargetNetworkResponse model) {
            super(model);
            associationId(model.associationId);
            status(model.status);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final AssociationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(AssociationStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(AssociationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public AssociateClientVpnTargetNetworkResponse build() {
            return new AssociateClientVpnTargetNetworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
