/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DnsEntry;
import software.amazon.awssdk.services.ec2.model.DnsEntrySetCopier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierSetCopier;
import software.amazon.awssdk.services.ec2.model.LastError;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdentifier;
import software.amazon.awssdk.services.ec2.model.State;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcEndpoint> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpoint.getter(VpcEndpoint::vpcEndpointId)).setter(VpcEndpoint.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("vpcEndpointId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpoint.getter(VpcEndpoint::vpcEndpointTypeAsString)).setter(VpcEndpoint.setter(Builder::vpcEndpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointType").unmarshallLocationName("vpcEndpointType").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpoint.getter(VpcEndpoint::vpcId)).setter(VpcEndpoint.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpoint.getter(VpcEndpoint::serviceName)).setter(VpcEndpoint.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").unmarshallLocationName("serviceName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpoint.getter(VpcEndpoint::stateAsString)).setter(VpcEndpoint.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpoint.getter(VpcEndpoint::policyDocument)).setter(VpcEndpoint.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").unmarshallLocationName("policyDocument").build()}).build();
    private static final SdkField<List<String>> ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcEndpoint.getter(VpcEndpoint::routeTableIds)).setter(VpcEndpoint.setter(Builder::routeTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableIdSet").unmarshallLocationName("routeTableIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcEndpoint.getter(VpcEndpoint::subnetIds)).setter(VpcEndpoint.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdSet").unmarshallLocationName("subnetIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<SecurityGroupIdentifier>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcEndpoint.getter(VpcEndpoint::groups)).setter(VpcEndpoint.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VpcEndpoint.getter(VpcEndpoint::privateDnsEnabled)).setter(VpcEndpoint.setter(Builder::privateDnsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEnabled").unmarshallLocationName("privateDnsEnabled").build()}).build();
    private static final SdkField<Boolean> REQUESTER_MANAGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VpcEndpoint.getter(VpcEndpoint::requesterManaged)).setter(VpcEndpoint.setter(Builder::requesterManaged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterManaged").unmarshallLocationName("requesterManaged").build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcEndpoint.getter(VpcEndpoint::networkInterfaceIds)).setter(VpcEndpoint.setter(Builder::networkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceIdSet").unmarshallLocationName("networkInterfaceIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<DnsEntry>> DNS_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcEndpoint.getter(VpcEndpoint::dnsEntries)).setter(VpcEndpoint.setter(Builder::dnsEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsEntrySet").unmarshallLocationName("dnsEntrySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VpcEndpoint.getter(VpcEndpoint::creationTimestamp)).setter(VpcEndpoint.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").unmarshallLocationName("creationTimestamp").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcEndpoint.getter(VpcEndpoint::tags)).setter(VpcEndpoint.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpoint.getter(VpcEndpoint::ownerId)).setter(VpcEndpoint.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<LastError> LAST_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VpcEndpoint.getter(VpcEndpoint::lastError)).setter(VpcEndpoint.setter(Builder::lastError)).constructor(LastError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastError").unmarshallLocationName("lastError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD, VPC_ENDPOINT_TYPE_FIELD, VPC_ID_FIELD, SERVICE_NAME_FIELD, STATE_FIELD, POLICY_DOCUMENT_FIELD, ROUTE_TABLE_IDS_FIELD, SUBNET_IDS_FIELD, GROUPS_FIELD, PRIVATE_DNS_ENABLED_FIELD, REQUESTER_MANAGED_FIELD, NETWORK_INTERFACE_IDS_FIELD, DNS_ENTRIES_FIELD, CREATION_TIMESTAMP_FIELD, TAGS_FIELD, OWNER_ID_FIELD, LAST_ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vpcEndpointId;
    private final String vpcEndpointType;
    private final String vpcId;
    private final String serviceName;
    private final String state;
    private final String policyDocument;
    private final List<String> routeTableIds;
    private final List<String> subnetIds;
    private final List<SecurityGroupIdentifier> groups;
    private final Boolean privateDnsEnabled;
    private final Boolean requesterManaged;
    private final List<String> networkInterfaceIds;
    private final List<DnsEntry> dnsEntries;
    private final Instant creationTimestamp;
    private final List<Tag> tags;
    private final String ownerId;
    private final LastError lastError;

    private VpcEndpoint(BuilderImpl builder) {
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointType = builder.vpcEndpointType;
        this.vpcId = builder.vpcId;
        this.serviceName = builder.serviceName;
        this.state = builder.state;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.subnetIds = builder.subnetIds;
        this.groups = builder.groups;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.requesterManaged = builder.requesterManaged;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.dnsEntries = builder.dnsEntries;
        this.creationTimestamp = builder.creationTimestamp;
        this.tags = builder.tags;
        this.ownerId = builder.ownerId;
        this.lastError = builder.lastError;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public VpcEndpointType vpcEndpointType() {
        return VpcEndpointType.fromValue(this.vpcEndpointType);
    }

    public String vpcEndpointTypeAsString() {
        return this.vpcEndpointType;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public State state() {
        return State.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public boolean hasRouteTableIds() {
        return this.routeTableIds != null && !(this.routeTableIds instanceof SdkAutoConstructList);
    }

    public List<String> routeTableIds() {
        return this.routeTableIds;
    }

    public boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<SecurityGroupIdentifier> groups() {
        return this.groups;
    }

    public Boolean privateDnsEnabled() {
        return this.privateDnsEnabled;
    }

    public Boolean requesterManaged() {
        return this.requesterManaged;
    }

    public boolean hasNetworkInterfaceIds() {
        return this.networkInterfaceIds != null && !(this.networkInterfaceIds instanceof SdkAutoConstructList);
    }

    public List<String> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    public boolean hasDnsEntries() {
        return this.dnsEntries != null && !(this.dnsEntries instanceof SdkAutoConstructList);
    }

    public List<DnsEntry> dnsEntries() {
        return this.dnsEntries;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public LastError lastError() {
        return this.lastError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterManaged());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastError());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpoint)) {
            return false;
        }
        VpcEndpoint other = (VpcEndpoint)obj;
        return Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.vpcEndpointTypeAsString(), other.vpcEndpointTypeAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.routeTableIds(), other.routeTableIds()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.privateDnsEnabled(), other.privateDnsEnabled()) && Objects.equals(this.requesterManaged(), other.requesterManaged()) && Objects.equals(this.networkInterfaceIds(), other.networkInterfaceIds()) && Objects.equals(this.dnsEntries(), other.dnsEntries()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.lastError(), other.lastError());
    }

    public String toString() {
        return ToString.builder((String)"VpcEndpoint").add("VpcEndpointId", (Object)this.vpcEndpointId()).add("VpcEndpointType", (Object)this.vpcEndpointTypeAsString()).add("VpcId", (Object)this.vpcId()).add("ServiceName", (Object)this.serviceName()).add("State", (Object)this.stateAsString()).add("PolicyDocument", (Object)this.policyDocument()).add("RouteTableIds", this.routeTableIds()).add("SubnetIds", this.subnetIds()).add("Groups", this.groups()).add("PrivateDnsEnabled", (Object)this.privateDnsEnabled()).add("RequesterManaged", (Object)this.requesterManaged()).add("NetworkInterfaceIds", this.networkInterfaceIds()).add("DnsEntries", this.dnsEntries()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Tags", this.tags()).add("OwnerId", (Object)this.ownerId()).add("LastError", (Object)this.lastError()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "VpcEndpointType": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointTypeAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "RouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.routeTableIds()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "PrivateDnsEnabled": {
                return Optional.ofNullable(clazz.cast(this.privateDnsEnabled()));
            }
            case "RequesterManaged": {
                return Optional.ofNullable(clazz.cast(this.requesterManaged()));
            }
            case "NetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceIds()));
            }
            case "DnsEntries": {
                return Optional.ofNullable(clazz.cast(this.dnsEntries()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "LastError": {
                return Optional.ofNullable(clazz.cast(this.lastError()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpoint, T> g) {
        return obj -> g.apply((VpcEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcEndpointId;
        private String vpcEndpointType;
        private String vpcId;
        private String serviceName;
        private String state;
        private String policyDocument;
        private List<String> routeTableIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<SecurityGroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();
        private Boolean privateDnsEnabled;
        private Boolean requesterManaged;
        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private List<DnsEntry> dnsEntries = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTimestamp;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;
        private LastError lastError;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpoint model) {
            this.vpcEndpointId(model.vpcEndpointId);
            this.vpcEndpointType(model.vpcEndpointType);
            this.vpcId(model.vpcId);
            this.serviceName(model.serviceName);
            this.state(model.state);
            this.policyDocument(model.policyDocument);
            this.routeTableIds(model.routeTableIds);
            this.subnetIds(model.subnetIds);
            this.groups(model.groups);
            this.privateDnsEnabled(model.privateDnsEnabled);
            this.requesterManaged(model.requesterManaged);
            this.networkInterfaceIds(model.networkInterfaceIds);
            this.dnsEntries(model.dnsEntries);
            this.creationTimestamp(model.creationTimestamp);
            this.tags(model.tags);
            this.ownerId(model.ownerId);
            this.lastError(model.lastError);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getVpcEndpointTypeAsString() {
            return this.vpcEndpointType;
        }

        @Override
        public final Builder vpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        @Override
        public final Builder vpcEndpointType(VpcEndpointType vpcEndpointType) {
            this.vpcEndpointType(vpcEndpointType == null ? null : vpcEndpointType.toString());
            return this;
        }

        public final void setVpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String ... routeTableIds) {
            this.routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ValueStringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ValueStringListCopier.copy(subnetIds);
        }

        public final Collection<SecurityGroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(SecurityGroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<SecurityGroupIdentifier> groups) {
            this.groups = GroupIdentifierSetCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(SecurityGroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<SecurityGroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (SecurityGroupIdentifier)((SecurityGroupIdentifier.Builder)SecurityGroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<SecurityGroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierSetCopier.copyFromBuilder(groups);
        }

        public final Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        public final Boolean getRequesterManaged() {
            return this.requesterManaged;
        }

        @Override
        public final Builder requesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
            return this;
        }

        public final void setRequesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            return this.networkInterfaceIds;
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ValueStringListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String ... networkInterfaceIds) {
            this.networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ValueStringListCopier.copy(networkInterfaceIds);
        }

        public final Collection<DnsEntry.Builder> getDnsEntries() {
            return this.dnsEntries != null ? (Collection)this.dnsEntries.stream().map(DnsEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dnsEntries(Collection<DnsEntry> dnsEntries) {
            this.dnsEntries = DnsEntrySetCopier.copy(dnsEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsEntries(DnsEntry ... dnsEntries) {
            this.dnsEntries(Arrays.asList(dnsEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsEntries(Consumer<DnsEntry.Builder> ... dnsEntries) {
            this.dnsEntries(Stream.of(dnsEntries).map(c -> (DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDnsEntries(Collection<DnsEntry.BuilderImpl> dnsEntries) {
            this.dnsEntries = DnsEntrySetCopier.copyFromBuilder(dnsEntries);
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final LastError.Builder getLastError() {
            return this.lastError != null ? this.lastError.toBuilder() : null;
        }

        @Override
        public final Builder lastError(LastError lastError) {
            this.lastError = lastError;
            return this;
        }

        public final void setLastError(LastError.BuilderImpl lastError) {
            this.lastError = lastError != null ? lastError.build() : null;
        }

        public VpcEndpoint build() {
            return new VpcEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcEndpoint> {
        public Builder vpcEndpointId(String var1);

        public Builder vpcEndpointType(String var1);

        public Builder vpcEndpointType(VpcEndpointType var1);

        public Builder vpcId(String var1);

        public Builder serviceName(String var1);

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder policyDocument(String var1);

        public Builder routeTableIds(Collection<String> var1);

        public Builder routeTableIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder groups(Collection<SecurityGroupIdentifier> var1);

        public Builder groups(SecurityGroupIdentifier ... var1);

        public Builder groups(Consumer<SecurityGroupIdentifier.Builder> ... var1);

        public Builder privateDnsEnabled(Boolean var1);

        public Builder requesterManaged(Boolean var1);

        public Builder networkInterfaceIds(Collection<String> var1);

        public Builder networkInterfaceIds(String ... var1);

        public Builder dnsEntries(Collection<DnsEntry> var1);

        public Builder dnsEntries(DnsEntry ... var1);

        public Builder dnsEntries(Consumer<DnsEntry.Builder> ... var1);

        public Builder creationTimestamp(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder ownerId(String var1);

        public Builder lastError(LastError var1);

        default public Builder lastError(Consumer<LastError.Builder> lastError) {
            return this.lastError((LastError)((LastError.Builder)LastError.builder().applyMutation(lastError)).build());
        }
    }
}

