/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayMulticastRegisteredGroupSources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayMulticastRegisteredGroupSources> {
    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayMulticastRegisteredGroupSources.getter(TransitGatewayMulticastRegisteredGroupSources::transitGatewayMulticastDomainId)).setter(TransitGatewayMulticastRegisteredGroupSources.setter(Builder::transitGatewayMulticastDomainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId").unmarshallLocationName("transitGatewayMulticastDomainId").build()}).build();
    private static final SdkField<List<String>> REGISTERED_NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TransitGatewayMulticastRegisteredGroupSources.getter(TransitGatewayMulticastRegisteredGroupSources::registeredNetworkInterfaceIds)).setter(TransitGatewayMulticastRegisteredGroupSources.setter(Builder::registeredNetworkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredNetworkInterfaceIds").unmarshallLocationName("registeredNetworkInterfaceIds").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> GROUP_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayMulticastRegisteredGroupSources.getter(TransitGatewayMulticastRegisteredGroupSources::groupIpAddress)).setter(TransitGatewayMulticastRegisteredGroupSources.setter(Builder::groupIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIpAddress").unmarshallLocationName("groupIpAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, REGISTERED_NETWORK_INTERFACE_IDS_FIELD, GROUP_IP_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayMulticastDomainId;
    private final List<String> registeredNetworkInterfaceIds;
    private final String groupIpAddress;

    private TransitGatewayMulticastRegisteredGroupSources(BuilderImpl builder) {
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.registeredNetworkInterfaceIds = builder.registeredNetworkInterfaceIds;
        this.groupIpAddress = builder.groupIpAddress;
    }

    public String transitGatewayMulticastDomainId() {
        return this.transitGatewayMulticastDomainId;
    }

    public List<String> registeredNetworkInterfaceIds() {
        return this.registeredNetworkInterfaceIds;
    }

    public String groupIpAddress() {
        return this.groupIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredNetworkInterfaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIpAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastRegisteredGroupSources)) {
            return false;
        }
        TransitGatewayMulticastRegisteredGroupSources other = (TransitGatewayMulticastRegisteredGroupSources)obj;
        return Objects.equals(this.transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId()) && Objects.equals(this.registeredNetworkInterfaceIds(), other.registeredNetworkInterfaceIds()) && Objects.equals(this.groupIpAddress(), other.groupIpAddress());
    }

    public String toString() {
        return ToString.builder((String)"TransitGatewayMulticastRegisteredGroupSources").add("TransitGatewayMulticastDomainId", (Object)this.transitGatewayMulticastDomainId()).add("RegisteredNetworkInterfaceIds", this.registeredNetworkInterfaceIds()).add("GroupIpAddress", (Object)this.groupIpAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayMulticastDomainId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayMulticastDomainId()));
            }
            case "RegisteredNetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.registeredNetworkInterfaceIds()));
            }
            case "GroupIpAddress": {
                return Optional.ofNullable(clazz.cast(this.groupIpAddress()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastRegisteredGroupSources, T> g) {
        return obj -> g.apply((TransitGatewayMulticastRegisteredGroupSources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayMulticastDomainId;
        private List<String> registeredNetworkInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private String groupIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastRegisteredGroupSources model) {
            this.transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            this.registeredNetworkInterfaceIds(model.registeredNetworkInterfaceIds);
            this.groupIpAddress(model.groupIpAddress);
        }

        public final String getTransitGatewayMulticastDomainId() {
            return this.transitGatewayMulticastDomainId;
        }

        @Override
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        public final Collection<String> getRegisteredNetworkInterfaceIds() {
            return this.registeredNetworkInterfaceIds;
        }

        @Override
        public final Builder registeredNetworkInterfaceIds(Collection<String> registeredNetworkInterfaceIds) {
            this.registeredNetworkInterfaceIds = ValueStringListCopier.copy(registeredNetworkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registeredNetworkInterfaceIds(String ... registeredNetworkInterfaceIds) {
            this.registeredNetworkInterfaceIds(Arrays.asList(registeredNetworkInterfaceIds));
            return this;
        }

        public final void setRegisteredNetworkInterfaceIds(Collection<String> registeredNetworkInterfaceIds) {
            this.registeredNetworkInterfaceIds = ValueStringListCopier.copy(registeredNetworkInterfaceIds);
        }

        public final String getGroupIpAddress() {
            return this.groupIpAddress;
        }

        @Override
        public final Builder groupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        public final void setGroupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
        }

        public TransitGatewayMulticastRegisteredGroupSources build() {
            return new TransitGatewayMulticastRegisteredGroupSources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayMulticastRegisteredGroupSources> {
        public Builder transitGatewayMulticastDomainId(String var1);

        public Builder registeredNetworkInterfaceIds(Collection<String> var1);

        public Builder registeredNetworkInterfaceIds(String ... var1);

        public Builder groupIpAddress(String var1);
    }
}

