/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceTypeOffering;
import software.amazon.awssdk.services.ec2.model.InstanceTypeOfferingsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceTypeOfferingsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInstanceTypeOfferingsResponse> {
    private static final SdkField<List<InstanceTypeOffering>> INSTANCE_TYPE_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeInstanceTypeOfferingsResponse.getter(DescribeInstanceTypeOfferingsResponse::instanceTypeOfferings)).setter(DescribeInstanceTypeOfferingsResponse.setter(Builder::instanceTypeOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeOfferingSet").unmarshallLocationName("instanceTypeOfferingSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTypeOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeInstanceTypeOfferingsResponse.getter(DescribeInstanceTypeOfferingsResponse::nextToken)).setter(DescribeInstanceTypeOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_OFFERINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<InstanceTypeOffering> instanceTypeOfferings;
    private final String nextToken;

    private DescribeInstanceTypeOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceTypeOfferings = builder.instanceTypeOfferings;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceTypeOffering> instanceTypeOfferings() {
        return this.instanceTypeOfferings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeOfferings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceTypeOfferingsResponse)) {
            return false;
        }
        DescribeInstanceTypeOfferingsResponse other = (DescribeInstanceTypeOfferingsResponse)((Object)obj);
        return Objects.equals(this.instanceTypeOfferings(), other.instanceTypeOfferings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstanceTypeOfferingsResponse").add("InstanceTypeOfferings", this.instanceTypeOfferings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceTypeOfferings": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeOfferings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceTypeOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeInstanceTypeOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceTypeOffering> instanceTypeOfferings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceTypeOfferingsResponse model) {
            super(model);
            this.instanceTypeOfferings(model.instanceTypeOfferings);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceTypeOffering.Builder> getInstanceTypeOfferings() {
            return this.instanceTypeOfferings != null ? (Collection)this.instanceTypeOfferings.stream().map(InstanceTypeOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceTypeOfferings(Collection<InstanceTypeOffering> instanceTypeOfferings) {
            this.instanceTypeOfferings = InstanceTypeOfferingsListCopier.copy(instanceTypeOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeOfferings(InstanceTypeOffering ... instanceTypeOfferings) {
            this.instanceTypeOfferings(Arrays.asList(instanceTypeOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeOfferings(Consumer<InstanceTypeOffering.Builder> ... instanceTypeOfferings) {
            this.instanceTypeOfferings(Stream.of(instanceTypeOfferings).map(c -> (InstanceTypeOffering)((InstanceTypeOffering.Builder)InstanceTypeOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceTypeOfferings(Collection<InstanceTypeOffering.BuilderImpl> instanceTypeOfferings) {
            this.instanceTypeOfferings = InstanceTypeOfferingsListCopier.copyFromBuilder(instanceTypeOfferings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceTypeOfferingsResponse build() {
            return new DescribeInstanceTypeOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceTypeOfferingsResponse> {
        public Builder instanceTypeOfferings(Collection<InstanceTypeOffering> var1);

        public Builder instanceTypeOfferings(InstanceTypeOffering ... var1);

        public Builder instanceTypeOfferings(Consumer<InstanceTypeOffering.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

