/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayRouteTablesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayRouteTablesResponse> {
    private static final SdkField<List<TransitGatewayRouteTable>> TRANSIT_GATEWAY_ROUTE_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTransitGatewayRouteTablesResponse.getter(DescribeTransitGatewayRouteTablesResponse::transitGatewayRouteTables)).setter(DescribeTransitGatewayRouteTablesResponse.setter(Builder::transitGatewayRouteTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTables").unmarshallLocationName("transitGatewayRouteTables").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayRouteTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTransitGatewayRouteTablesResponse.getter(DescribeTransitGatewayRouteTablesResponse::nextToken)).setter(DescribeTransitGatewayRouteTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ROUTE_TABLES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayRouteTable> transitGatewayRouteTables;
    private final String nextToken;

    private DescribeTransitGatewayRouteTablesResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRouteTables = builder.transitGatewayRouteTables;
        this.nextToken = builder.nextToken;
    }

    public List<TransitGatewayRouteTable> transitGatewayRouteTables() {
        return this.transitGatewayRouteTables;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTables());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayRouteTablesResponse)) {
            return false;
        }
        DescribeTransitGatewayRouteTablesResponse other = (DescribeTransitGatewayRouteTablesResponse)((Object)obj);
        return Objects.equals(this.transitGatewayRouteTables(), other.transitGatewayRouteTables()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTransitGatewayRouteTablesResponse").add("TransitGatewayRouteTables", this.transitGatewayRouteTables()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayRouteTables": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTables()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayRouteTablesResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayRouteTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayRouteTable> transitGatewayRouteTables = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayRouteTablesResponse model) {
            super(model);
            this.transitGatewayRouteTables(model.transitGatewayRouteTables);
            this.nextToken(model.nextToken);
        }

        public final Collection<TransitGatewayRouteTable.Builder> getTransitGatewayRouteTables() {
            return this.transitGatewayRouteTables != null ? (Collection)this.transitGatewayRouteTables.stream().map(TransitGatewayRouteTable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitGatewayRouteTables(Collection<TransitGatewayRouteTable> transitGatewayRouteTables) {
            this.transitGatewayRouteTables = TransitGatewayRouteTableListCopier.copy(transitGatewayRouteTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayRouteTables(TransitGatewayRouteTable ... transitGatewayRouteTables) {
            this.transitGatewayRouteTables(Arrays.asList(transitGatewayRouteTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayRouteTables(Consumer<TransitGatewayRouteTable.Builder> ... transitGatewayRouteTables) {
            this.transitGatewayRouteTables(Stream.of(transitGatewayRouteTables).map(c -> (TransitGatewayRouteTable)((TransitGatewayRouteTable.Builder)TransitGatewayRouteTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransitGatewayRouteTables(Collection<TransitGatewayRouteTable.BuilderImpl> transitGatewayRouteTables) {
            this.transitGatewayRouteTables = TransitGatewayRouteTableListCopier.copyFromBuilder(transitGatewayRouteTables);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTransitGatewayRouteTablesResponse build() {
            return new DescribeTransitGatewayRouteTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayRouteTablesResponse> {
        public Builder transitGatewayRouteTables(Collection<TransitGatewayRouteTable> var1);

        public Builder transitGatewayRouteTables(TransitGatewayRouteTable ... var1);

        public Builder transitGatewayRouteTables(Consumer<TransitGatewayRouteTable.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

