/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocateAddressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AllocateAddressRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AllocateAddressRequest.getter(AllocateAddressRequest::domainAsString)).setter(AllocateAddressRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").unmarshallLocationName("Domain").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AllocateAddressRequest.getter(AllocateAddressRequest::address)).setter(AllocateAddressRequest.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").unmarshallLocationName("Address").build()}).build();
    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AllocateAddressRequest.getter(AllocateAddressRequest::publicIpv4Pool)).setter(AllocateAddressRequest.setter(Builder::publicIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool").unmarshallLocationName("PublicIpv4Pool").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, ADDRESS_FIELD, PUBLIC_IPV4_POOL_FIELD));
    private final String domain;
    private final String address;
    private final String publicIpv4Pool;

    private AllocateAddressRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.address = builder.address;
        this.publicIpv4Pool = builder.publicIpv4Pool;
    }

    public DomainType domain() {
        return DomainType.fromValue(this.domain);
    }

    public String domainAsString() {
        return this.domain;
    }

    public String address() {
        return this.address;
    }

    public String publicIpv4Pool() {
        return this.publicIpv4Pool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpv4Pool());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressRequest)) {
            return false;
        }
        AllocateAddressRequest other = (AllocateAddressRequest)((Object)obj);
        return Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.publicIpv4Pool(), other.publicIpv4Pool());
    }

    public String toString() {
        return ToString.builder((String)"AllocateAddressRequest").add("Domain", (Object)this.domainAsString()).add("Address", (Object)this.address()).add("PublicIpv4Pool", (Object)this.publicIpv4Pool()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "PublicIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.publicIpv4Pool()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateAddressRequest, T> g) {
        return obj -> g.apply((AllocateAddressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String domain;
        private String address;
        private String publicIpv4Pool;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressRequest model) {
            super(model);
            this.domain(model.domain);
            this.address(model.address);
            this.publicIpv4Pool(model.publicIpv4Pool);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getPublicIpv4Pool() {
            return this.publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateAddressRequest build() {
            return new AllocateAddressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocateAddressRequest> {
        public Builder domain(String var1);

        public Builder domain(DomainType var1);

        public Builder address(String var1);

        public Builder publicIpv4Pool(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

