/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ScheduledInstance;
import software.amazon.awssdk.services.ec2.transform.ScheduledInstanceRecurrenceUnmarshaller;

public class ScheduledInstanceUnmarshaller
implements Unmarshaller<ScheduledInstance, StaxUnmarshallerContext> {
    private static final ScheduledInstanceUnmarshaller INSTANCE = new ScheduledInstanceUnmarshaller();

    public ScheduledInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ScheduledInstance.Builder scheduledInstance = ScheduledInstance.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("availabilityZone", targetDepth)) {
                    scheduledInstance.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("createDate", targetDepth)) {
                    scheduledInstance.createDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hourlyPrice", targetDepth)) {
                    scheduledInstance.hourlyPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceCount", targetDepth)) {
                    scheduledInstance.instanceCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceType", targetDepth)) {
                    scheduledInstance.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("networkPlatform", targetDepth)) {
                    scheduledInstance.networkPlatform(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("nextSlotStartTime", targetDepth)) {
                    scheduledInstance.nextSlotStartTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("platform", targetDepth)) {
                    scheduledInstance.platform(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("previousSlotEndTime", targetDepth)) {
                    scheduledInstance.previousSlotEndTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("recurrence", targetDepth)) {
                    scheduledInstance.recurrence(ScheduledInstanceRecurrenceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("scheduledInstanceId", targetDepth)) {
                    scheduledInstance.scheduledInstanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("slotDurationInHours", targetDepth)) {
                    scheduledInstance.slotDurationInHours(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("termEndDate", targetDepth)) {
                    scheduledInstance.termEndDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("termStartDate", targetDepth)) {
                    scheduledInstance.termStartDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("totalScheduledInstanceHours", targetDepth)) continue;
                scheduledInstance.totalScheduledInstanceHours(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ScheduledInstance)scheduledInstance.build();
    }

    public static ScheduledInstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

