/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.PrefixList;

public class PrefixListUnmarshaller
implements Unmarshaller<PrefixList, StaxUnmarshallerContext> {
    private static final PrefixListUnmarshaller INSTANCE = new PrefixListUnmarshaller();

    public PrefixList unmarshall(StaxUnmarshallerContext context) throws Exception {
        PrefixList.Builder prefixList;
        block7: {
            prefixList = PrefixList.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> cidrs = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    prefixList.cidrs(cidrs);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("cidrSet", targetDepth)) {
                        cidrs = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("cidrSet/item", targetDepth)) {
                        cidrs.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("prefixListId", targetDepth)) {
                        prefixList.prefixListId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("prefixListName", targetDepth)) continue;
                    prefixList.prefixListName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            prefixList.cidrs(cidrs);
        }
        return (PrefixList)prefixList.build();
    }

    public static PrefixListUnmarshaller getInstance() {
        return INSTANCE;
    }
}

