/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ElasticGpus;
import software.amazon.awssdk.services.ec2.transform.ElasticGpuHealthUnmarshaller;

public class ElasticGpusUnmarshaller
implements Unmarshaller<ElasticGpus, StaxUnmarshallerContext> {
    private static final ElasticGpusUnmarshaller INSTANCE = new ElasticGpusUnmarshaller();

    public ElasticGpus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ElasticGpus.Builder elasticGpus = ElasticGpus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("elasticGpuId", targetDepth)) {
                    elasticGpus.elasticGpuId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    elasticGpus.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("elasticGpuType", targetDepth)) {
                    elasticGpus.elasticGpuType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("elasticGpuHealth", targetDepth)) {
                    elasticGpus.elasticGpuHealth(ElasticGpuHealthUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("elasticGpuState", targetDepth)) {
                    elasticGpus.elasticGpuState(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instanceId", targetDepth)) continue;
                elasticGpus.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ElasticGpus)elasticGpus.build();
    }

    public static ElasticGpusUnmarshaller getInstance() {
        return INSTANCE;
    }
}

