/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;

public class DiskImageDetailUnmarshaller
implements Unmarshaller<DiskImageDetail, StaxUnmarshallerContext> {
    private static final DiskImageDetailUnmarshaller INSTANCE = new DiskImageDetailUnmarshaller();

    public DiskImageDetail unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DiskImageDetail.Builder diskImageDetail = DiskImageDetail.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("bytes", targetDepth)) {
                    diskImageDetail.bytes(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("format", targetDepth)) {
                    diskImageDetail.format(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("importManifestUrl", targetDepth)) continue;
                diskImageDetail.importManifestUrl(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DiskImageDetail)diskImageDetail.build();
    }

    public static DiskImageDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}

