/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest;

public class DetachNetworkInterfaceRequestMarshaller
implements Marshaller<Request<DetachNetworkInterfaceRequest>, DetachNetworkInterfaceRequest> {
    public Request<DetachNetworkInterfaceRequest> marshall(DetachNetworkInterfaceRequest detachNetworkInterfaceRequest) {
        if (detachNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)detachNetworkInterfaceRequest, "EC2Client");
        request.addParameter("Action", "DetachNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachNetworkInterfaceRequest.attachmentId() != null) {
            request.addParameter("AttachmentId", StringUtils.fromString((String)detachNetworkInterfaceRequest.attachmentId()));
        }
        if (detachNetworkInterfaceRequest.force() != null) {
            request.addParameter("Force", StringUtils.fromBoolean((Boolean)detachNetworkInterfaceRequest.force()));
        }
        return request;
    }
}

