/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcPeeringConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpcPeeringConnectionsRequest>, DescribeVpcPeeringConnectionsRequest> {
    public Request<DescribeVpcPeeringConnectionsRequest> marshall(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        List<String> describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList;
        if (describeVpcPeeringConnectionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpcPeeringConnectionsRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcPeeringConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVpcPeeringConnectionsRequestFiltersList = describeVpcPeeringConnectionsRequest.filters();
        if (describeVpcPeeringConnectionsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeVpcPeeringConnectionsRequestFiltersListValue : describeVpcPeeringConnectionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcPeeringConnectionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpcPeeringConnectionsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeVpcPeeringConnectionsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList = describeVpcPeeringConnectionsRequest.vpcPeeringConnectionIds()) != null) {
            int vpcPeeringConnectionIdsListIndex = 1;
            for (String describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsListValue : describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList) {
                if (describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsListValue != null) {
                    request.addParameter("VpcPeeringConnectionId." + vpcPeeringConnectionIdsListIndex, StringUtils.fromString((String)describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsListValue));
                }
                ++vpcPeeringConnectionIdsListIndex;
            }
        }
        return request;
    }
}

