/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest;

public class ConfirmProductInstanceRequestMarshaller
implements Marshaller<Request<ConfirmProductInstanceRequest>, ConfirmProductInstanceRequest> {
    public Request<ConfirmProductInstanceRequest> marshall(ConfirmProductInstanceRequest confirmProductInstanceRequest) {
        if (confirmProductInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)confirmProductInstanceRequest, "EC2Client");
        request.addParameter("Action", "ConfirmProductInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (confirmProductInstanceRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)confirmProductInstanceRequest.instanceId()));
        }
        if (confirmProductInstanceRequest.productCode() != null) {
            request.addParameter("ProductCode", StringUtils.fromString((String)confirmProductInstanceRequest.productCode()));
        }
        return request;
    }
}

