/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.AccountAttribute;
import software.amazon.awssdk.services.ec2.model.AccountAttributeValue;
import software.amazon.awssdk.services.ec2.transform.AccountAttributeValueUnmarshaller;

public class AccountAttributeUnmarshaller
implements Unmarshaller<AccountAttribute, StaxUnmarshallerContext> {
    private static final AccountAttributeUnmarshaller INSTANCE = new AccountAttributeUnmarshaller();

    public AccountAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        AccountAttribute.Builder accountAttribute;
        block6: {
            accountAttribute = AccountAttribute.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<AccountAttributeValue> attributeValues = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    accountAttribute.attributeValues(attributeValues);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("attributeName", targetDepth)) {
                        accountAttribute.attributeName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("attributeValueSet", targetDepth)) {
                        attributeValues = new ArrayList<AccountAttributeValue>();
                        continue;
                    }
                    if (!context.testExpression("attributeValueSet/item", targetDepth)) continue;
                    attributeValues.add(AccountAttributeValueUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            accountAttribute.attributeValues(attributeValues);
        }
        return (AccountAttribute)accountAttribute.build();
    }

    public static AccountAttributeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

