/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotPlacement
implements ToCopyableBuilder<Builder, SpotPlacement> {
    private final String availabilityZone;
    private final String groupName;
    private final String tenancy;

    private SpotPlacement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.groupName = builder.groupName;
        this.tenancy = builder.tenancy;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String groupName() {
        return this.groupName;
    }

    public Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public String tenancyString() {
        return this.tenancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotPlacement)) {
            return false;
        }
        SpotPlacement other = (SpotPlacement)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.tenancyString(), other.tenancyString());
    }

    public String toString() {
        return ToString.builder((String)"SpotPlacement").add("AvailabilityZone", (Object)this.availabilityZone()).add("GroupName", (Object)this.groupName()).add("Tenancy", (Object)this.tenancyString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "Tenancy": {
                return Optional.of(clazz.cast(this.tenancyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String groupName;
        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotPlacement model) {
            this.availabilityZone(model.availabilityZone);
            this.groupName(model.groupName);
            this.tenancy(model.tenancy);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public SpotPlacement build() {
            return new SpotPlacement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotPlacement> {
        public Builder availabilityZone(String var1);

        public Builder groupName(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);
    }
}

