/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.Monitoring;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceMonitoring
implements ToCopyableBuilder<Builder, InstanceMonitoring> {
    private final String instanceId;
    private final Monitoring monitoring;

    private InstanceMonitoring(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.monitoring = builder.monitoring;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Monitoring monitoring() {
        return this.monitoring;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMonitoring)) {
            return false;
        }
        InstanceMonitoring other = (InstanceMonitoring)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.monitoring(), other.monitoring());
    }

    public String toString() {
        return ToString.builder((String)"InstanceMonitoring").add("InstanceId", (Object)this.instanceId()).add("Monitoring", (Object)this.monitoring()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Monitoring": {
                return Optional.of(clazz.cast(this.monitoring()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private Monitoring monitoring;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMonitoring model) {
            this.instanceId(model.instanceId);
            this.monitoring(model.monitoring);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Monitoring.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Monitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public InstanceMonitoring build() {
            return new InstanceMonitoring(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceMonitoring> {
        public Builder instanceId(String var1);

        public Builder monitoring(Monitoring var1);

        default public Builder monitoring(Consumer<Monitoring.Builder> monitoring) {
            return this.monitoring((Monitoring)((Monitoring.Builder)Monitoring.builder().apply(monitoring)).build());
        }
    }
}

