/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.DiskImage;
import software.amazon.awssdk.services.ec2.model.DiskImageListCopier;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportInstanceRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ImportInstanceRequest> {
    private final String description;
    private final List<DiskImage> diskImages;
    private final ImportInstanceLaunchSpecification launchSpecification;
    private final String platform;

    private ImportInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.diskImages = builder.diskImages;
        this.launchSpecification = builder.launchSpecification;
        this.platform = builder.platform;
    }

    public String description() {
        return this.description;
    }

    public List<DiskImage> diskImages() {
        return this.diskImages;
    }

    public ImportInstanceLaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public PlatformValues platform() {
        return PlatformValues.fromValue(this.platform);
    }

    public String platformString() {
        return this.platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskImages());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceRequest)) {
            return false;
        }
        ImportInstanceRequest other = (ImportInstanceRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.diskImages(), other.diskImages()) && Objects.equals(this.launchSpecification(), other.launchSpecification()) && Objects.equals(this.platformString(), other.platformString());
    }

    public String toString() {
        return ToString.builder((String)"ImportInstanceRequest").add("Description", (Object)this.description()).add("DiskImages", this.diskImages()).add("LaunchSpecification", (Object)this.launchSpecification()).add("Platform", (Object)this.platformString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DiskImages": {
                return Optional.of(clazz.cast(this.diskImages()));
            }
            case "LaunchSpecification": {
                return Optional.of(clazz.cast(this.launchSpecification()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platformString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String description;
        private List<DiskImage> diskImages;
        private ImportInstanceLaunchSpecification launchSpecification;
        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceRequest model) {
            this.description(model.description);
            this.diskImages(model.diskImages);
            this.launchSpecification(model.launchSpecification);
            this.platform(model.platform);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DiskImage.Builder> getDiskImages() {
            return this.diskImages != null ? (Collection)this.diskImages.stream().map(DiskImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder diskImages(Collection<DiskImage> diskImages) {
            this.diskImages = DiskImageListCopier.copy(diskImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskImages(DiskImage ... diskImages) {
            this.diskImages(Arrays.asList(diskImages));
            return this;
        }

        public final void setDiskImages(Collection<DiskImage.BuilderImpl> diskImages) {
            this.diskImages = DiskImageListCopier.copyFromBuilder(diskImages);
        }

        public final ImportInstanceLaunchSpecification.Builder getLaunchSpecification() {
            return this.launchSpecification != null ? this.launchSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(ImportInstanceLaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ImportInstanceRequest build() {
            return new ImportInstanceRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ImportInstanceRequest> {
        public Builder description(String var1);

        public Builder diskImages(Collection<DiskImage> var1);

        public Builder diskImages(DiskImage ... var1);

        public Builder launchSpecification(ImportInstanceLaunchSpecification var1);

        default public Builder launchSpecification(Consumer<ImportInstanceLaunchSpecification.Builder> launchSpecification) {
            return this.launchSpecification((ImportInstanceLaunchSpecification)((ImportInstanceLaunchSpecification.Builder)ImportInstanceLaunchSpecification.builder().apply(launchSpecification)).build());
        }

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

