/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.Purchase;
import software.amazon.awssdk.services.ec2.model.PurchaseSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHostReservationPurchasePreviewResponse
extends EC2Response
implements ToCopyableBuilder<Builder, GetHostReservationPurchasePreviewResponse> {
    private final String currencyCode;
    private final List<Purchase> purchase;
    private final String totalHourlyPrice;
    private final String totalUpfrontPrice;

    private GetHostReservationPurchasePreviewResponse(BuilderImpl builder) {
        super(builder);
        this.currencyCode = builder.currencyCode;
        this.purchase = builder.purchase;
        this.totalHourlyPrice = builder.totalHourlyPrice;
        this.totalUpfrontPrice = builder.totalUpfrontPrice;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeString() {
        return this.currencyCode;
    }

    public List<Purchase> purchase() {
        return this.purchase;
    }

    public String totalHourlyPrice() {
        return this.totalHourlyPrice;
    }

    public String totalUpfrontPrice() {
        return this.totalUpfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchase());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalHourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalUpfrontPrice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewResponse)) {
            return false;
        }
        GetHostReservationPurchasePreviewResponse other = (GetHostReservationPurchasePreviewResponse)((Object)obj);
        return Objects.equals(this.currencyCodeString(), other.currencyCodeString()) && Objects.equals(this.purchase(), other.purchase()) && Objects.equals(this.totalHourlyPrice(), other.totalHourlyPrice()) && Objects.equals(this.totalUpfrontPrice(), other.totalUpfrontPrice());
    }

    public String toString() {
        return ToString.builder((String)"GetHostReservationPurchasePreviewResponse").add("CurrencyCode", (Object)this.currencyCodeString()).add("Purchase", this.purchase()).add("TotalHourlyPrice", (Object)this.totalHourlyPrice()).add("TotalUpfrontPrice", (Object)this.totalUpfrontPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeString()));
            }
            case "Purchase": {
                return Optional.of(clazz.cast(this.purchase()));
            }
            case "TotalHourlyPrice": {
                return Optional.of(clazz.cast(this.totalHourlyPrice()));
            }
            case "TotalUpfrontPrice": {
                return Optional.of(clazz.cast(this.totalUpfrontPrice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String currencyCode;
        private List<Purchase> purchase;
        private String totalHourlyPrice;
        private String totalUpfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewResponse model) {
            this.currencyCode(model.currencyCode);
            this.purchase(model.purchase);
            this.totalHourlyPrice(model.totalHourlyPrice);
            this.totalUpfrontPrice(model.totalUpfrontPrice);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<Purchase.Builder> getPurchase() {
            return this.purchase != null ? (Collection)this.purchase.stream().map(Purchase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Purchase ... purchase) {
            this.purchase(Arrays.asList(purchase));
            return this;
        }

        public final void setPurchase(Collection<Purchase.BuilderImpl> purchase) {
            this.purchase = PurchaseSetCopier.copyFromBuilder(purchase);
        }

        public final String getTotalHourlyPrice() {
            return this.totalHourlyPrice;
        }

        @Override
        public final Builder totalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
            return this;
        }

        public final void setTotalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
        }

        public final String getTotalUpfrontPrice() {
            return this.totalUpfrontPrice;
        }

        @Override
        public final Builder totalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
            return this;
        }

        public final void setTotalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
        }

        @Override
        public GetHostReservationPurchasePreviewResponse build() {
            return new GetHostReservationPurchasePreviewResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, GetHostReservationPurchasePreviewResponse> {
        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder purchase(Collection<Purchase> var1);

        public Builder purchase(Purchase ... var1);

        public Builder totalHourlyPrice(String var1);

        public Builder totalUpfrontPrice(String var1);
    }
}

