/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.FpgaImageStateCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FpgaImageState
implements ToCopyableBuilder<Builder, FpgaImageState> {
    private final String code;
    private final String message;

    private FpgaImageState(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    public FpgaImageStateCode code() {
        return FpgaImageStateCode.fromValue(this.code);
    }

    public String codeString() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImageState)) {
            return false;
        }
        FpgaImageState other = (FpgaImageState)obj;
        return Objects.equals(this.codeString(), other.codeString()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"FpgaImageState").add("Code", (Object)this.codeString()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.of(clazz.cast(this.codeString()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImageState model) {
            this.code(model.code);
            this.message(model.message);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(FpgaImageStateCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public FpgaImageState build() {
            return new FpgaImageState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FpgaImageState> {
        public Builder code(String var1);

        public Builder code(FpgaImageStateCode var1);

        public Builder message(String var1);
    }
}

