/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.AttachmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EbsInstanceBlockDevice
implements ToCopyableBuilder<Builder, EbsInstanceBlockDevice> {
    private final Instant attachTime;
    private final Boolean deleteOnTermination;
    private final String status;
    private final String volumeId;

    private EbsInstanceBlockDevice(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.status = builder.status;
        this.volumeId = builder.volumeId;
    }

    public Instant attachTime() {
        return this.attachTime;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public AttachmentStatus status() {
        return AttachmentStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsInstanceBlockDevice)) {
            return false;
        }
        EbsInstanceBlockDevice other = (EbsInstanceBlockDevice)obj;
        return Objects.equals(this.attachTime(), other.attachTime()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public String toString() {
        return ToString.builder((String)"EbsInstanceBlockDevice").add("AttachTime", (Object)this.attachTime()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("Status", (Object)this.statusString()).add("VolumeId", (Object)this.volumeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachTime": {
                return Optional.of(clazz.cast(this.attachTime()));
            }
            case "DeleteOnTermination": {
                return Optional.of(clazz.cast(this.deleteOnTermination()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "VolumeId": {
                return Optional.of(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant attachTime;
        private Boolean deleteOnTermination;
        private String status;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsInstanceBlockDevice model) {
            this.attachTime(model.attachTime);
            this.deleteOnTermination(model.deleteOnTermination);
            this.status(model.status);
            this.volumeId(model.volumeId);
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public EbsInstanceBlockDevice build() {
            return new EbsInstanceBlockDevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsInstanceBlockDevice> {
        public Builder attachTime(Instant var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder status(String var1);

        public Builder status(AttachmentStatus var1);

        public Builder volumeId(String var1);
    }
}

