/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetachVpnGatewayRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DetachVpnGatewayRequest> {
    private final String vpcId;
    private final String vpnGatewayId;

    private DetachVpnGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.vpnGatewayId = builder.vpnGatewayId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGatewayId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachVpnGatewayRequest)) {
            return false;
        }
        DetachVpnGatewayRequest other = (DetachVpnGatewayRequest)((Object)obj);
        return Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.vpnGatewayId(), other.vpnGatewayId());
    }

    public String toString() {
        return ToString.builder((String)"DetachVpnGatewayRequest").add("VpcId", (Object)this.vpcId()).add("VpnGatewayId", (Object)this.vpnGatewayId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "VpnGatewayId": {
                return Optional.of(clazz.cast(this.vpnGatewayId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String vpcId;
        private String vpnGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachVpnGatewayRequest model) {
            this.vpcId(model.vpcId);
            this.vpnGatewayId(model.vpnGatewayId);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DetachVpnGatewayRequest build() {
            return new DetachVpnGatewayRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DetachVpnGatewayRequest> {
        public Builder vpcId(String var1);

        public Builder vpnGatewayId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

