/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailabilitySetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledInstanceAvailabilityResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityResponse> {
    private final String nextToken;
    private final List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet;

    private DescribeScheduledInstanceAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduledInstanceAvailabilitySet = builder.scheduledInstanceAvailabilitySet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet() {
        return this.scheduledInstanceAvailabilitySet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledInstanceAvailabilitySet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityResponse)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityResponse other = (DescribeScheduledInstanceAvailabilityResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.scheduledInstanceAvailabilitySet(), other.scheduledInstanceAvailabilitySet());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScheduledInstanceAvailabilityResponse").add("NextToken", (Object)this.nextToken()).add("ScheduledInstanceAvailabilitySet", this.scheduledInstanceAvailabilitySet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ScheduledInstanceAvailabilitySet": {
                return Optional.of(clazz.cast(this.scheduledInstanceAvailabilitySet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityResponse model) {
            this.nextToken(model.nextToken);
            this.scheduledInstanceAvailabilitySet(model.scheduledInstanceAvailabilitySet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ScheduledInstanceAvailability.Builder> getScheduledInstanceAvailabilitySet() {
            return this.scheduledInstanceAvailabilitySet != null ? (Collection)this.scheduledInstanceAvailabilitySet.stream().map(ScheduledInstanceAvailability::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier.copy(scheduledInstanceAvailabilitySet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability ... scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet(Arrays.asList(scheduledInstanceAvailabilitySet));
            return this;
        }

        public final void setScheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability.BuilderImpl> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier.copyFromBuilder(scheduledInstanceAvailabilitySet);
        }

        @Override
        public DescribeScheduledInstanceAvailabilityResponse build() {
            return new DescribeScheduledInstanceAvailabilityResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityResponse> {
        public Builder nextToken(String var1);

        public Builder scheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> var1);

        public Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability ... var1);
    }
}

