/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteRouteTableRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DeleteRouteTableRequest> {
    private final String routeTableId;

    private DeleteRouteTableRequest(BuilderImpl builder) {
        super(builder);
        this.routeTableId = builder.routeTableId;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteTableRequest)) {
            return false;
        }
        DeleteRouteTableRequest other = (DeleteRouteTableRequest)((Object)obj);
        return Objects.equals(this.routeTableId(), other.routeTableId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteRouteTableRequest").add("RouteTableId", (Object)this.routeTableId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteTableId": {
                return Optional.of(clazz.cast(this.routeTableId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteTableRequest model) {
            this.routeTableId(model.routeTableId);
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteRouteTableRequest build() {
            return new DeleteRouteTableRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DeleteRouteTableRequest> {
        public Builder routeTableId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

