/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVpcPeeringConnectionRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
    private final String peerOwnerId;
    private final String peerVpcId;
    private final String vpcId;

    private CreateVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.peerOwnerId = builder.peerOwnerId;
        this.peerVpcId = builder.peerVpcId;
        this.vpcId = builder.vpcId;
    }

    public String peerOwnerId() {
        return this.peerOwnerId;
    }

    public String peerVpcId() {
        return this.peerVpcId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.peerOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionRequest)) {
            return false;
        }
        CreateVpcPeeringConnectionRequest other = (CreateVpcPeeringConnectionRequest)((Object)obj);
        return Objects.equals(this.peerOwnerId(), other.peerOwnerId()) && Objects.equals(this.peerVpcId(), other.peerVpcId()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcPeeringConnectionRequest").add("PeerOwnerId", (Object)this.peerOwnerId()).add("PeerVpcId", (Object)this.peerVpcId()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PeerOwnerId": {
                return Optional.of(clazz.cast(this.peerOwnerId()));
            }
            case "PeerVpcId": {
                return Optional.of(clazz.cast(this.peerVpcId()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String peerOwnerId;
        private String peerVpcId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionRequest model) {
            this.peerOwnerId(model.peerOwnerId);
            this.peerVpcId(model.peerVpcId);
            this.vpcId(model.vpcId);
        }

        public final String getPeerOwnerId() {
            return this.peerOwnerId;
        }

        @Override
        public final Builder peerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
            return this;
        }

        public final void setPeerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
        }

        public final String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcPeeringConnectionRequest build() {
            return new CreateVpcPeeringConnectionRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
        public Builder peerOwnerId(String var1);

        public Builder peerVpcId(String var1);

        public Builder vpcId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

