/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesRequest;

public class UnmonitorInstancesRequestMarshaller
implements Marshaller<Request<UnmonitorInstancesRequest>, UnmonitorInstancesRequest> {
    public Request<UnmonitorInstancesRequest> marshall(UnmonitorInstancesRequest unmonitorInstancesRequest) {
        if (unmonitorInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)unmonitorInstancesRequest, "EC2Client");
        request.addParameter("Action", "UnmonitorInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> unmonitorInstancesRequestInstanceIdsList = unmonitorInstancesRequest.instanceIds();
        if (unmonitorInstancesRequestInstanceIdsList != null) {
            int instanceIdsListIndex = 1;
            for (String unmonitorInstancesRequestInstanceIdsListValue : unmonitorInstancesRequestInstanceIdsList) {
                if (unmonitorInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)unmonitorInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

