/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.StorageLocation;

public class StorageLocationUnmarshaller
implements Unmarshaller<StorageLocation, StaxUnmarshallerContext> {
    private static final StorageLocationUnmarshaller INSTANCE = new StorageLocationUnmarshaller();

    public StorageLocation unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StorageLocation.Builder storageLocation = StorageLocation.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Bucket", targetDepth)) {
                    storageLocation.bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Key", targetDepth)) continue;
                storageLocation.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StorageLocation)storageLocation.build();
    }

    public static StorageLocationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

