/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.InstanceStateChange;
import software.amazon.awssdk.services.ec2.model.StopInstancesResponse;
import software.amazon.awssdk.services.ec2.transform.InstanceStateChangeUnmarshaller;

public class StopInstancesResponseUnmarshaller
implements Unmarshaller<StopInstancesResponse, StaxUnmarshallerContext> {
    private static final StopInstancesResponseUnmarshaller INSTANCE = new StopInstancesResponseUnmarshaller();

    public StopInstancesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        StopInstancesResponse.Builder stopInstancesResponse;
        block5: {
            stopInstancesResponse = StopInstancesResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<InstanceStateChange> stoppingInstances = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    stopInstancesResponse.stoppingInstances(stoppingInstances);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("instancesSet", targetDepth)) {
                        stoppingInstances = new ArrayList<InstanceStateChange>();
                        continue;
                    }
                    if (!context.testExpression("instancesSet/item", targetDepth)) continue;
                    stoppingInstances.add(InstanceStateChangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            stopInstancesResponse.stoppingInstances(stoppingInstances);
        }
        return (StopInstancesResponse)((Object)stopInstancesResponse.build());
    }

    public static StopInstancesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

