/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.RegisterImageRequest;

public class RegisterImageRequestMarshaller
implements Marshaller<Request<RegisterImageRequest>, RegisterImageRequest> {
    public Request<RegisterImageRequest> marshall(RegisterImageRequest registerImageRequest) {
        List<String> registerImageRequestBillingProductsList;
        List<BlockDeviceMapping> registerImageRequestBlockDeviceMappingsList;
        if (registerImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)registerImageRequest, "EC2Client");
        request.addParameter("Action", "RegisterImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerImageRequest.imageLocation() != null) {
            request.addParameter("ImageLocation", StringUtils.fromString((String)registerImageRequest.imageLocation()));
        }
        if (registerImageRequest.architectureString() != null) {
            request.addParameter("Architecture", StringUtils.fromString((String)registerImageRequest.architectureString()));
        }
        if ((registerImageRequestBlockDeviceMappingsList = registerImageRequest.blockDeviceMappings()) != null) {
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping registerImageRequestBlockDeviceMappingsListValue : registerImageRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (registerImageRequestBlockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)registerImageRequestBlockDeviceMappingsListValue.deviceName()));
                }
                if (registerImageRequestBlockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)registerImageRequestBlockDeviceMappingsListValue.virtualName()));
                }
                if ((ebs = registerImageRequestBlockDeviceMappingsListValue.ebs()) != null) {
                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.encrypted()));
                    }
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.iops()));
                    }
                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.snapshotId()));
                    }
                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.volumeSize()));
                    }
                    if (ebs.volumeTypeString() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.volumeTypeString()));
                    }
                }
                if (registerImageRequestBlockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)registerImageRequestBlockDeviceMappingsListValue.noDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (registerImageRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)registerImageRequest.description()));
        }
        if (registerImageRequest.enaSupport() != null) {
            request.addParameter("EnaSupport", StringUtils.fromBoolean((Boolean)registerImageRequest.enaSupport()));
        }
        if (registerImageRequest.kernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString((String)registerImageRequest.kernelId()));
        }
        if (registerImageRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)registerImageRequest.name()));
        }
        if ((registerImageRequestBillingProductsList = registerImageRequest.billingProducts()) != null) {
            int billingProductsListIndex = 1;
            for (String registerImageRequestBillingProductsListValue : registerImageRequestBillingProductsList) {
                if (registerImageRequestBillingProductsListValue != null) {
                    request.addParameter("BillingProduct." + billingProductsListIndex, StringUtils.fromString((String)registerImageRequestBillingProductsListValue));
                }
                ++billingProductsListIndex;
            }
        }
        if (registerImageRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString((String)registerImageRequest.ramdiskId()));
        }
        if (registerImageRequest.rootDeviceName() != null) {
            request.addParameter("RootDeviceName", StringUtils.fromString((String)registerImageRequest.rootDeviceName()));
        }
        if (registerImageRequest.sriovNetSupport() != null) {
            request.addParameter("SriovNetSupport", StringUtils.fromString((String)registerImageRequest.sriovNetSupport()));
        }
        if (registerImageRequest.virtualizationType() != null) {
            request.addParameter("VirtualizationType", StringUtils.fromString((String)registerImageRequest.virtualizationType()));
        }
        return request;
    }
}

