/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest;

public class CreateVpcEndpointRequestMarshaller
implements Marshaller<Request<CreateVpcEndpointRequest>, CreateVpcEndpointRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateVpcEndpointRequest> marshall(CreateVpcEndpointRequest createVpcEndpointRequest) {
        List<String> createVpcEndpointRequestSecurityGroupIdsList;
        List<String> createVpcEndpointRequestSubnetIdsList;
        List<String> createVpcEndpointRequestRouteTableIdsList;
        if (createVpcEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createVpcEndpointRequest, "EC2Client");
        request.addParameter("Action", "CreateVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcEndpointRequest.vpcEndpointTypeString() != null) {
            request.addParameter("VpcEndpointType", StringUtils.fromString((String)createVpcEndpointRequest.vpcEndpointTypeString()));
        }
        if (createVpcEndpointRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)createVpcEndpointRequest.vpcId()));
        }
        if (createVpcEndpointRequest.serviceName() != null) {
            request.addParameter("ServiceName", StringUtils.fromString((String)createVpcEndpointRequest.serviceName()));
        }
        if (createVpcEndpointRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)createVpcEndpointRequest.policyDocument()));
        }
        if ((createVpcEndpointRequestRouteTableIdsList = createVpcEndpointRequest.routeTableIds()) != null) {
            int routeTableIdsListIndex = 1;
            for (String string : createVpcEndpointRequestRouteTableIdsList) {
                if (string != null) {
                    request.addParameter("RouteTableId." + routeTableIdsListIndex, StringUtils.fromString((String)string));
                }
                ++routeTableIdsListIndex;
            }
        }
        if ((createVpcEndpointRequestSubnetIdsList = createVpcEndpointRequest.subnetIds()) != null) {
            int subnetIdsListIndex = 1;
            for (String createVpcEndpointRequestSubnetIdsListValue : createVpcEndpointRequestSubnetIdsList) {
                if (createVpcEndpointRequestSubnetIdsListValue != null) {
                    request.addParameter("SubnetId." + subnetIdsListIndex, StringUtils.fromString((String)createVpcEndpointRequestSubnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if ((createVpcEndpointRequestSecurityGroupIdsList = createVpcEndpointRequest.securityGroupIds()) != null) {
            boolean bl = true;
            for (String createVpcEndpointRequestSecurityGroupIdsListValue : createVpcEndpointRequestSecurityGroupIdsList) {
                void var6_12;
                if (createVpcEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + (int)var6_12, StringUtils.fromString((String)createVpcEndpointRequestSecurityGroupIdsListValue));
                }
                ++var6_12;
            }
        }
        if (createVpcEndpointRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createVpcEndpointRequest.clientToken()));
        }
        if (createVpcEndpointRequest.privateDnsEnabled() != null) {
            request.addParameter("PrivateDnsEnabled", StringUtils.fromBoolean((Boolean)createVpcEndpointRequest.privateDnsEnabled()));
        }
        return request;
    }
}

