/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest;

public class CreatePlacementGroupRequestMarshaller
implements Marshaller<Request<CreatePlacementGroupRequest>, CreatePlacementGroupRequest> {
    public Request<CreatePlacementGroupRequest> marshall(CreatePlacementGroupRequest createPlacementGroupRequest) {
        if (createPlacementGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createPlacementGroupRequest, "EC2Client");
        request.addParameter("Action", "CreatePlacementGroup");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlacementGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)createPlacementGroupRequest.groupName()));
        }
        if (createPlacementGroupRequest.strategyString() != null) {
            request.addParameter("Strategy", StringUtils.fromString((String)createPlacementGroupRequest.strategyString()));
        }
        return request;
    }
}

