/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.IcmpTypeCode;
import software.amazon.awssdk.services.ec2.model.PortRange;

public class CreateNetworkAclEntryRequestMarshaller
implements Marshaller<Request<CreateNetworkAclEntryRequest>, CreateNetworkAclEntryRequest> {
    public Request<CreateNetworkAclEntryRequest> marshall(CreateNetworkAclEntryRequest createNetworkAclEntryRequest) {
        PortRange portRange;
        IcmpTypeCode icmpTypeCode;
        if (createNetworkAclEntryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createNetworkAclEntryRequest, "EC2Client");
        request.addParameter("Action", "CreateNetworkAclEntry");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkAclEntryRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)createNetworkAclEntryRequest.cidrBlock()));
        }
        if (createNetworkAclEntryRequest.egress() != null) {
            request.addParameter("Egress", StringUtils.fromBoolean((Boolean)createNetworkAclEntryRequest.egress()));
        }
        if ((icmpTypeCode = createNetworkAclEntryRequest.icmpTypeCode()) != null) {
            if (icmpTypeCode.code() != null) {
                request.addParameter("Icmp.Code", StringUtils.fromInteger((Integer)icmpTypeCode.code()));
            }
            if (icmpTypeCode.type() != null) {
                request.addParameter("Icmp.Type", StringUtils.fromInteger((Integer)icmpTypeCode.type()));
            }
        }
        if (createNetworkAclEntryRequest.ipv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString((String)createNetworkAclEntryRequest.ipv6CidrBlock()));
        }
        if (createNetworkAclEntryRequest.networkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString((String)createNetworkAclEntryRequest.networkAclId()));
        }
        if ((portRange = createNetworkAclEntryRequest.portRange()) != null) {
            if (portRange.from() != null) {
                request.addParameter("PortRange.From", StringUtils.fromInteger((Integer)portRange.from()));
            }
            if (portRange.to() != null) {
                request.addParameter("PortRange.To", StringUtils.fromInteger((Integer)portRange.to()));
            }
        }
        if (createNetworkAclEntryRequest.protocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createNetworkAclEntryRequest.protocol()));
        }
        if (createNetworkAclEntryRequest.ruleActionString() != null) {
            request.addParameter("RuleAction", StringUtils.fromString((String)createNetworkAclEntryRequest.ruleActionString()));
        }
        if (createNetworkAclEntryRequest.ruleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger((Integer)createNetworkAclEntryRequest.ruleNumber()));
        }
        return request;
    }
}

