/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.Volume;

public final class DescribeVolumesPaginator
implements SdkIterable<DescribeVolumesResponse> {
    private final EC2Client client;
    private final DescribeVolumesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeVolumesPaginator(EC2Client client, DescribeVolumesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVolumesResponseFetcher();
    }

    public Iterator<DescribeVolumesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Volume> volumes() {
        Function<DescribeVolumesResponse, Iterator> getIterator = response -> response != null ? response.volumes().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeVolumesResponseFetcher
    implements NextPageFetcher<DescribeVolumesResponse> {
        private DescribeVolumesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeVolumesResponse nextPage(DescribeVolumesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumesPaginator.this.client.describeVolumes(DescribeVolumesPaginator.this.firstRequest);
            }
            return DescribeVolumesPaginator.this.client.describeVolumes((DescribeVolumesRequest)((Object)DescribeVolumesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

