/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReason;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcPeeringConnection
implements ToCopyableBuilder<Builder, VpcPeeringConnection> {
    private final VpcPeeringConnectionVpcInfo accepterVpcInfo;
    private final Instant expirationTime;
    private final VpcPeeringConnectionVpcInfo requesterVpcInfo;
    private final VpcPeeringConnectionStateReason status;
    private final List<Tag> tags;
    private final String vpcPeeringConnectionId;

    private VpcPeeringConnection(BuilderImpl builder) {
        this.accepterVpcInfo = builder.accepterVpcInfo;
        this.expirationTime = builder.expirationTime;
        this.requesterVpcInfo = builder.requesterVpcInfo;
        this.status = builder.status;
        this.tags = builder.tags;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public VpcPeeringConnectionVpcInfo accepterVpcInfo() {
        return this.accepterVpcInfo;
    }

    public Instant expirationTime() {
        return this.expirationTime;
    }

    public VpcPeeringConnectionVpcInfo requesterVpcInfo() {
        return this.requesterVpcInfo;
    }

    public VpcPeeringConnectionStateReason status() {
        return this.status;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accepterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnection)) {
            return false;
        }
        VpcPeeringConnection other = (VpcPeeringConnection)obj;
        return Objects.equals(this.accepterVpcInfo(), other.accepterVpcInfo()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.requesterVpcInfo(), other.requesterVpcInfo()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accepterVpcInfo() != null) {
            sb.append("AccepterVpcInfo: ").append(this.accepterVpcInfo()).append(",");
        }
        if (this.expirationTime() != null) {
            sb.append("ExpirationTime: ").append(this.expirationTime()).append(",");
        }
        if (this.requesterVpcInfo() != null) {
            sb.append("RequesterVpcInfo: ").append(this.requesterVpcInfo()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(this.vpcPeeringConnectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccepterVpcInfo": {
                return Optional.of(clazz.cast(this.accepterVpcInfo()));
            }
            case "ExpirationTime": {
                return Optional.of(clazz.cast(this.expirationTime()));
            }
            case "RequesterVpcInfo": {
                return Optional.of(clazz.cast(this.requesterVpcInfo()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.of(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private VpcPeeringConnectionVpcInfo accepterVpcInfo;
        private Instant expirationTime;
        private VpcPeeringConnectionVpcInfo requesterVpcInfo;
        private VpcPeeringConnectionStateReason status;
        private List<Tag> tags;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnection model) {
            this.accepterVpcInfo(model.accepterVpcInfo);
            this.expirationTime(model.expirationTime);
            this.requesterVpcInfo(model.requesterVpcInfo);
            this.status(model.status);
            this.tags(model.tags);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final VpcPeeringConnectionVpcInfo.Builder getAccepterVpcInfo() {
            return this.accepterVpcInfo != null ? this.accepterVpcInfo.toBuilder() : null;
        }

        @Override
        public final Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo;
            return this;
        }

        public final void setAccepterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo != null ? accepterVpcInfo.build() : null;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final VpcPeeringConnectionVpcInfo.Builder getRequesterVpcInfo() {
            return this.requesterVpcInfo != null ? this.requesterVpcInfo.toBuilder() : null;
        }

        @Override
        public final Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo;
            return this;
        }

        public final void setRequesterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo != null ? requesterVpcInfo.build() : null;
        }

        public final VpcPeeringConnectionStateReason.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(VpcPeeringConnectionStateReason status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VpcPeeringConnectionStateReason.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        public VpcPeeringConnection build() {
            return new VpcPeeringConnection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcPeeringConnection> {
        public Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo var1);

        default public Builder accepterVpcInfo(Consumer<VpcPeeringConnectionVpcInfo.Builder> accepterVpcInfo) {
            return this.accepterVpcInfo((VpcPeeringConnectionVpcInfo)((VpcPeeringConnectionVpcInfo.Builder)VpcPeeringConnectionVpcInfo.builder().apply(accepterVpcInfo)).build());
        }

        public Builder expirationTime(Instant var1);

        public Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo var1);

        default public Builder requesterVpcInfo(Consumer<VpcPeeringConnectionVpcInfo.Builder> requesterVpcInfo) {
            return this.requesterVpcInfo((VpcPeeringConnectionVpcInfo)((VpcPeeringConnectionVpcInfo.Builder)VpcPeeringConnectionVpcInfo.builder().apply(requesterVpcInfo)).build());
        }

        public Builder status(VpcPeeringConnectionStateReason var1);

        default public Builder status(Consumer<VpcPeeringConnectionStateReason.Builder> status) {
            return this.status((VpcPeeringConnectionStateReason)((VpcPeeringConnectionStateReason.Builder)VpcPeeringConnectionStateReason.builder().apply(status)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vpcPeeringConnectionId(String var1);
    }
}

