/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeStatusEvent
implements ToCopyableBuilder<Builder, VolumeStatusEvent> {
    private final String description;
    private final String eventId;
    private final String eventType;
    private final Instant notAfter;
    private final Instant notBefore;

    private VolumeStatusEvent(BuilderImpl builder) {
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
    }

    public String description() {
        return this.description;
    }

    public String eventId() {
        return this.eventId;
    }

    public String eventType() {
        return this.eventType;
    }

    public Instant notAfter() {
        return this.notAfter;
    }

    public Instant notBefore() {
        return this.notBefore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusEvent)) {
            return false;
        }
        VolumeStatusEvent other = (VolumeStatusEvent)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.notBefore(), other.notBefore());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.eventId() != null) {
            sb.append("EventId: ").append(this.eventId()).append(",");
        }
        if (this.eventType() != null) {
            sb.append("EventType: ").append(this.eventType()).append(",");
        }
        if (this.notAfter() != null) {
            sb.append("NotAfter: ").append(this.notAfter()).append(",");
        }
        if (this.notBefore() != null) {
            sb.append("NotBefore: ").append(this.notBefore()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "EventId": {
                return Optional.of(clazz.cast(this.eventId()));
            }
            case "EventType": {
                return Optional.of(clazz.cast(this.eventType()));
            }
            case "NotAfter": {
                return Optional.of(clazz.cast(this.notAfter()));
            }
            case "NotBefore": {
                return Optional.of(clazz.cast(this.notBefore()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String eventId;
        private String eventType;
        private Instant notAfter;
        private Instant notBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusEvent model) {
            this.description(model.description);
            this.eventId(model.eventId);
            this.eventType(model.eventType);
            this.notAfter(model.notAfter);
            this.notBefore(model.notBefore);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public VolumeStatusEvent build() {
            return new VolumeStatusEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeStatusEvent> {
        public Builder description(String var1);

        public Builder eventId(String var1);

        public Builder eventType(String var1);

        public Builder notAfter(Instant var1);

        public Builder notBefore(Instant var1);
    }
}

