/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName;
import software.amazon.awssdk.services.ec2.model.LoadPermissionModifications;
import software.amazon.awssdk.services.ec2.model.OperationType;
import software.amazon.awssdk.services.ec2.model.ProductCodeStringListCopier;
import software.amazon.awssdk.services.ec2.model.UserGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.UserIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyFpgaImageAttributeRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ModifyFpgaImageAttributeRequest> {
    private final String fpgaImageId;
    private final String attribute;
    private final String operationType;
    private final List<String> userIds;
    private final List<String> userGroups;
    private final List<String> productCodes;
    private final LoadPermissionModifications loadPermission;
    private final String description;
    private final String name;

    private ModifyFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
        this.operationType = builder.operationType;
        this.userIds = builder.userIds;
        this.userGroups = builder.userGroups;
        this.productCodes = builder.productCodes;
        this.loadPermission = builder.loadPermission;
        this.description = builder.description;
        this.name = builder.name;
    }

    public String fpgaImageId() {
        return this.fpgaImageId;
    }

    public FpgaImageAttributeName attribute() {
        return FpgaImageAttributeName.fromValue(this.attribute);
    }

    public String attributeString() {
        return this.attribute;
    }

    public OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public String operationTypeString() {
        return this.operationType;
    }

    public List<String> userIds() {
        return this.userIds;
    }

    public List<String> userGroups() {
        return this.userGroups;
    }

    public List<String> productCodes() {
        return this.productCodes;
    }

    public LoadPermissionModifications loadPermission() {
        return this.loadPermission;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadPermission());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFpgaImageAttributeRequest)) {
            return false;
        }
        ModifyFpgaImageAttributeRequest other = (ModifyFpgaImageAttributeRequest)((Object)obj);
        return Objects.equals(this.fpgaImageId(), other.fpgaImageId()) && Objects.equals(this.attributeString(), other.attributeString()) && Objects.equals(this.operationTypeString(), other.operationTypeString()) && Objects.equals(this.userIds(), other.userIds()) && Objects.equals(this.userGroups(), other.userGroups()) && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.loadPermission(), other.loadPermission()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fpgaImageId() != null) {
            sb.append("FpgaImageId: ").append(this.fpgaImageId()).append(",");
        }
        if (this.attributeString() != null) {
            sb.append("Attribute: ").append(this.attributeString()).append(",");
        }
        if (this.operationTypeString() != null) {
            sb.append("OperationType: ").append(this.operationTypeString()).append(",");
        }
        if (this.userIds() != null) {
            sb.append("UserIds: ").append(this.userIds()).append(",");
        }
        if (this.userGroups() != null) {
            sb.append("UserGroups: ").append(this.userGroups()).append(",");
        }
        if (this.productCodes() != null) {
            sb.append("ProductCodes: ").append(this.productCodes()).append(",");
        }
        if (this.loadPermission() != null) {
            sb.append("LoadPermission: ").append(this.loadPermission()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageId": {
                return Optional.of(clazz.cast(this.fpgaImageId()));
            }
            case "Attribute": {
                return Optional.of(clazz.cast(this.attributeString()));
            }
            case "OperationType": {
                return Optional.of(clazz.cast(this.operationTypeString()));
            }
            case "UserIds": {
                return Optional.of(clazz.cast(this.userIds()));
            }
            case "UserGroups": {
                return Optional.of(clazz.cast(this.userGroups()));
            }
            case "ProductCodes": {
                return Optional.of(clazz.cast(this.productCodes()));
            }
            case "LoadPermission": {
                return Optional.of(clazz.cast(this.loadPermission()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String fpgaImageId;
        private String attribute;
        private String operationType;
        private List<String> userIds;
        private List<String> userGroups;
        private List<String> productCodes;
        private LoadPermissionModifications loadPermission;
        private String description;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyFpgaImageAttributeRequest model) {
            this.fpgaImageId(model.fpgaImageId);
            this.attribute(model.attribute);
            this.operationType(model.operationType);
            this.userIds(model.userIds);
            this.userGroups(model.userGroups);
            this.productCodes(model.productCodes);
            this.loadPermission(model.loadPermission);
            this.description(model.description);
            this.name(model.name);
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(FpgaImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final Collection<String> getUserIds() {
            return this.userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        public final Collection<String> getUserGroups() {
            return this.userGroups;
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String ... userGroups) {
            this.userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
        }

        public final Collection<String> getProductCodes() {
            return this.productCodes;
        }

        @Override
        public final Builder productCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(String ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
        }

        public final LoadPermissionModifications.Builder getLoadPermission() {
            return this.loadPermission != null ? this.loadPermission.toBuilder() : null;
        }

        @Override
        public final Builder loadPermission(LoadPermissionModifications loadPermission) {
            this.loadPermission = loadPermission;
            return this;
        }

        public final void setLoadPermission(LoadPermissionModifications.BuilderImpl loadPermission) {
            this.loadPermission = loadPermission != null ? loadPermission.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyFpgaImageAttributeRequest build() {
            return new ModifyFpgaImageAttributeRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ModifyFpgaImageAttributeRequest> {
        public Builder fpgaImageId(String var1);

        public Builder attribute(String var1);

        public Builder attribute(FpgaImageAttributeName var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder userGroups(Collection<String> var1);

        public Builder userGroups(String ... var1);

        public Builder productCodes(Collection<String> var1);

        public Builder productCodes(String ... var1);

        public Builder loadPermission(LoadPermissionModifications var1);

        default public Builder loadPermission(Consumer<LoadPermissionModifications.Builder> loadPermission) {
            return this.loadPermission((LoadPermissionModifications)((LoadPermissionModifications.Builder)LoadPermissionModifications.builder().apply(loadPermission)).build());
        }

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

