/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateSubnetRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreateSubnetRequest> {
    private final String availabilityZone;
    private final String cidrBlock;
    private final String ipv6CidrBlock;
    private final String vpcId;

    private CreateSubnetRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.vpcId = builder.vpcId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetRequest)) {
            return false;
        }
        CreateSubnetRequest other = (CreateSubnetRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.cidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.cidrBlock()).append(",");
        }
        if (this.ipv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(this.ipv6CidrBlock()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "CidrBlock": {
                return Optional.of(clazz.cast(this.cidrBlock()));
            }
            case "Ipv6CidrBlock": {
                return Optional.of(clazz.cast(this.ipv6CidrBlock()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String cidrBlock;
        private String ipv6CidrBlock;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetRequest model) {
            this.availabilityZone(model.availabilityZone);
            this.cidrBlock(model.cidrBlock);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.vpcId(model.vpcId);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateSubnetRequest build() {
            return new CreateSubnetRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreateSubnetRequest> {
        public Builder availabilityZone(String var1);

        public Builder cidrBlock(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder vpcId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

